<!--
Thank you for creating this pull request!

Provide a general summary of your changes in the Title above.
And please provide enough information in the description below, so that others can review your pull request (PR).
-->

## Pull Request Type

- [ ] I have checked there is no other PR open for the same change.

This is a:
- [ ] Bug fix
- [ ] New feature
- [ ] Code quality improvement

## Context
<!--
What do you want to achieve with this PR? Why did you write this code? What problem does this PR solve?
What should be mentioned about this PR in the changelog?
-->


## Detailed Description





## Quality assurance

- [ ] This change does NOT contain a breaking change (fix or feature that would cause existing functionality to change).
- [ ] I have commented my code, particularly in hard-to-understand areas.
- [ ] I have added unit tests to accompany this PR.
- [ ] The (new/existing) tests cover this PR 100%.
- [ ] I have (manually) tested this code to the best of my abilities.
- [ ] My code follows the style guidelines of this project.

## Documentation

For new features:
- [ ] I have added a code example showing how to use this feature to the [`examples`](https://github.com/WordPress/Requests/tree/develop/examples) directory.
- [ ] I have added documentation about this feature to the [`docs`](https://github.com/WordPress/Requests/tree/develop/docs) directory.
    If the documentation is in a new markdown file, I have added a link to this new file to the Docs folder [`README.md`](https://github.com/WordPress/Requests/tree/develop/docs/README.md) file.

<!--
============================================================================================
Please make sure your pull request passes all continuous integration checks!
I.e. code style complies with the project standard, the unit tests pass, code coverage has not gone down.

PRs which are failing their CI checks will likely be ignored by the maintainers.

PRs using atomic, descriptive commits are hugely appreciated as it will make reviewing your changes easier for the maintainers.
============================================================================================
-->
