@extends('layouts.admin')

@section('title', 'User Details: ' . $user->name)

@section('content')
<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">User Details: {{ $user->name }}</h3>
                    <div>
                        <a href="{{ route('admin.users.edit', $user->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Users
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">System Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">User ID:</div>
                                        <div class="col-sm-8">{{ $user->user_id ?? 'N/A' }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Email:</div>
                                        <div class="col-sm-8">{{ $user->email }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Status:</div>
                                        <div class="col-sm-8">
                                            <span class="badge bg-{{ $user->status === 'active' ? 'success' : ($user->status === 'inactive' ? 'warning' : 'danger') }}">
                                                {{ ucfirst($user->status) }}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Registered:</div>
                                        <div class="col-sm-8">{{ $user->created_at?->format('M d, Y h:i A') ?? 'N/A' }}</div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-4 fw-bold">Last Updated:</div>
                                        <div class="col-sm-8">{{ $user->updated_at?->format('M d, Y h:i A') ?? 'N/A' }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Company Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Company Name:</div>
                                        <div class="col-sm-8">{{ $user->company_name ?? 'N/A' }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Business Type:</div>
                                        <div class="col-sm-8">{{ $user->business_type ?? 'N/A' }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Contact Number:</div>
                                        <div class="col-sm-8">{{ $user->contact_number ?? 'N/A' }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Alternate Number:</div>
                                        <div class="col-sm-8">{{ $user->alternate_number ?? 'N/A' }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Website:</div>
                                        <div class="col-sm-8">
                                            @if($user->website)
                                                <a href="{{ $user->website }}" target="_blank">{{ $user->website }}</a>
                                            @else
                                                N/A
                                            @endif
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-4 fw-bold">GSTIN:</div>
                                        <div class="col-sm-8">{{ $user->gstin ?? 'N/A' }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Address</h5>
                        </div>
                        <div class="card-body">
                            <p>{{ $user->address ?? 'N/A' }}</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Wallet</h5>
                                    <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#creditWalletModal">
                                        <i class="fas fa-plus-circle"></i> Add Funds
                                    </button>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-2">
                                        <div class="col-sm-6 fw-bold">Current Balance</div>
                                        <div class="col-sm-6">₹ {{ number_format($user->wallet_balance ?? 0, 2) }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Recent Wallet Transactions</h5>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-striped mb-0">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Type</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse(($transactions ?? []) as $txn)
                                                <tr>
                                                    <td>{{ $txn->created_at?->format('M d, Y h:i A') ?? 'N/A' }}</td>
                                                    <td><span class="badge bg-{{ $txn->type === 'credit' ? 'success' : 'danger' }}">{{ ucfirst($txn->type ?? 'N/A') }}</span></td>
                                                    <td>₹ {{ number_format($txn->amount ?? 0, 2) }}</td>
                                                    <td>
                                                        <span class="badge bg-{{ $txn->status === 'completed' ? 'success' : ($txn->status === 'pending' ? 'warning' : 'danger') }}">
                                                            {{ ucfirst($txn->status ?? 'N/A') }}
                                                        </span>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="4" class="text-center text-muted">No transactions found.</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if($user->license)
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">License Information</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">License Key:</div>
                                        <div class="col-sm-8">
                                            <code>{{ $user->license?->key ?? 'N/A' }}</code>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Expiry Date:</div>
                                        <div class="col-sm-8">
                                            {{ $user->license?->expires_at?->format('M d, Y') ?? 'N/A' }}
                                            @if($user->license?->expires_at)
                                            <span class="badge bg-{{ $user->license->expires_at->isFuture() ? 'success' : 'danger' }} ms-2">
                                                {{ $user->license->expires_at->isFuture() ? 'Valid' : 'Expired' }}
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Status:</div>
                                        <div class="col-sm-8">
                                            <span class="badge bg-{{ $user->license?->is_active ? 'success' : 'danger' }}">
                                                {{ $user->license?->is_active ? 'Active' : 'Inactive' }}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-4 fw-bold">Created:</div>
                                        <div class="col-sm-8">{{ $user->license?->created_at?->format('M d, Y h:i A') ?? 'N/A' }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @else
                    <div class="alert alert-warning">
                        No license associated with this user.
                    </div>
                    @endif
                    
                    <!-- Credit Wallet Modal -->
                    <div class="modal fade" id="creditWalletModal" tabindex="-1" aria-labelledby="creditWalletModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="creditWalletModalLabel">Add Funds to Wallet</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form method="POST" action="{{ route('admin.users.wallet.credit', $user->id) }}">
                                    @csrf
                                    <div class="modal-body">
                                        <div class="mb-3">
                                            <label for="amount" class="form-label">Amount (INR)</label>
                                            <input id="amount" name="amount" type="number" min="1" step="1" class="form-control" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="note" class="form-label">Note (optional)</label>
                                            <input id="note" name="note" type="text" class="form-control" maxlength="255">
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-primary">Credit Wallet</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection