<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to DizzCall AI</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 700;
        }
        .header p {
            margin: 10px 0 0 0;
            opacity: 0.9;
            font-size: 16px;
        }
        .content {
            padding: 40px 30px;
        }
        .welcome-message {
            font-size: 18px;
            color: #4f46e5;
            font-weight: 600;
            margin-bottom: 20px;
        }
        .credentials-box {
            background: #f8fafc;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 25px;
            margin: 25px 0;
        }
        .credential-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 0;
            border-bottom: 1px solid #e2e8f0;
        }
        .credential-item:last-child {
            border-bottom: none;
        }
        .credential-label {
            font-weight: 600;
            color: #374151;
        }
        .credential-value {
            font-family: 'Courier New', monospace;
            background: #4f46e5;
            color: white;
            padding: 8px 12px;
            border-radius: 6px;
            font-weight: 600;
        }
        .login-button {
            display: inline-block;
            background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%);
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            margin: 20px 0;
            transition: transform 0.3s ease;
        }
        .login-button:hover {
            transform: translateY(-2px);
        }
        .security-note {
            background: #fef3c7;
            border-left: 4px solid #f59e0b;
            padding: 15px;
            margin: 20px 0;
            border-radius: 0 8px 8px 0;
        }
        .security-note strong {
            color: #92400e;
        }
        .footer {
            background: #f8fafc;
            padding: 20px 30px;
            text-align: center;
            color: #6b7280;
            font-size: 14px;
        }
        .footer a {
            color: #4f46e5;
            text-decoration: none;
        }
        .features {
            margin: 30px 0;
        }
        .feature-item {
            display: flex;
            align-items: center;
            margin: 15px 0;
            padding: 10px 0;
        }
        .feature-icon {
            width: 40px;
            height: 40px;
            background: #4f46e5;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-size: 16px;
        }
        .feature-text {
            flex: 1;
        }
        .feature-title {
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }
        .feature-description {
            color: #6b7280;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Welcome to DizzCall AI</h1>
            <p>Your AI-powered calling platform</p>
        </div>
        
        <div class="content">
            <div class="welcome-message">
                Hello {{ $user->name }},
            </div>
            
            <p>Welcome to DizzCall AI! Your account has been successfully created. We're excited to have you on board.</p>
            
            <div class="credentials-box">
                <h3 style="margin-top: 0; color: #374151; font-size: 18px;">Your Account Credentials</h3>
                
                <div class="credential-item">
                    <span class="credential-label">User ID:</span>
                    <span class="credential-value">USR-{{ $user->id }}</span>
                </div>
                
                <div class="credential-item">
                    <span class="credential-label">Email:</span>
                    <span class="credential-value">{{ $user->email }}</span>
                </div>
                
                <div class="credential-item">
                    <span class="credential-label">Password:</span>
                    <span class="credential-value">{{ $password }}</span>
                </div>
            </div>
            
            <div style="text-align: center;">
                <a href="{{ $loginUrl }}" class="login-button">Login to Your Account</a>
            </div>
            
            <div class="security-note">
                <strong>Security Note:</strong> Please change your password after your first login for security purposes. Keep your credentials safe and do not share them with anyone.
            </div>
            
            <div class="features">
                <h3 style="color: #374151; margin-bottom: 20px;">What you can do with DizzCall AI:</h3>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div class="feature-text">
                        <div class="feature-title">AI-Powered Calls</div>
                        <div class="feature-description">Make intelligent calls with AI assistance and automated responses</div>
                    </div>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-wallet"></i>
                    </div>
                    <div class="feature-text">
                        <div class="feature-title">Wallet Management</div>
                        <div class="feature-description">Manage your credits, view transaction history, and add funds easily</div>
                    </div>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-chart-bar"></i>
                    </div>
                    <div class="feature-text">
                        <div class="feature-title">Analytics & Reports</div>
                        <div class="feature-description">Track your call performance and get detailed insights</div>
                    </div>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <div class="feature-text">
                        <div class="feature-title">24/7 Support</div>
                        <div class="feature-description">Get help whenever you need it with our dedicated support team</div>
                    </div>
                </div>
            </div>
            
            <p>If you have any questions or need assistance, please don't hesitate to contact our support team.</p>
            
            <p>Best regards,<br>
            <strong>The DizzCall AI Team</strong></p>
        </div>
        
        <div class="footer">
            <p>This email was sent to {{ $user->email }}. If you didn't create this account, please ignore this email.</p>
            <p>&copy; {{ date('Y') }} DizzCall AI. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
