<?php

return [
    /*
    |--------------------------------------------------------------------------
    | AI Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for AI services including Phi-3 Mini model settings
    |
    */

    'phi3' => [
        'url' => env('PHI3_URL', 'http://localhost:11434/api/generate'),
        'api_key' => env('PHI3_API_KEY', 'phi3-mini-key'),
        'max_tokens' => env('PHI3_MAX_TOKENS', 500),
        'temperature' => env('PHI3_TEMPERATURE', 0.5),
        'timeout' => env('PHI3_TIMEOUT', 15),
        'model_name' => env('PHI3_MODEL_NAME', 'gemma:2b'),
    ],

    'voice' => [
        'speech_to_text' => [
            'provider' => env('STT_PROVIDER', 'local'), // local, azure, google
            'model' => env('STT_MODEL', 'whisper-1'),
            'language' => env('STT_LANGUAGE', 'en-US'),
        ],
        'text_to_speech' => [
            'provider' => env('TTS_PROVIDER', 'local'), // local, azure, google
            'voice' => env('TTS_VOICE', 'default'),
            'language' => env('TTS_LANGUAGE', 'en-US'),
        ],
    ],

    'conversation' => [
        'max_context_messages' => env('AI_MAX_CONTEXT_MESSAGES', 10),
        'max_conversation_length' => env('AI_MAX_CONVERSATION_LENGTH', 50),
        'auto_cleanup_days' => env('AI_AUTO_CLEANUP_DAYS', 30),
    ],

    'insights' => [
        'confidence_threshold' => env('AI_CONFIDENCE_THRESHOLD', 0.7),
        'enable_sentiment_analysis' => env('AI_ENABLE_SENTIMENT', true),
        'enable_intent_recognition' => env('AI_ENABLE_INTENT', true),
        'enable_entity_extraction' => env('AI_ENABLE_ENTITIES', true),
    ],

    'training' => [
        'data_path' => storage_path('app/ai/training'),
        'model_path' => storage_path('app/ai/models'),
        'logs_path' => storage_path('logs/ai'),
        'enable_continuous_learning' => env('AI_ENABLE_LEARNING', true),
    ],
];
