<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Twilio Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for Twilio phone integration
    |
    */

    'account_sid' => env('TWILIO_ACCOUNT_SID'),
    'auth_token' => env('TWILIO_AUTH_TOKEN'),
    'phone_number' => env('TWILIO_PHONE_NUMBER'),
    'webhook_url' => env('TWILIO_WEBHOOK_URL', env('APP_URL') . '/api/twilio/webhook'),
    
    /*
    |--------------------------------------------------------------------------
    | Voice Settings
    |--------------------------------------------------------------------------
    */
    
    'voice' => [
        'language' => 'en-US',
        'voice' => 'alice', // alice, man, woman
        'gender' => 'female',
        'speed' => 1.0,
        'pitch' => 1.0,
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Call Settings
    |--------------------------------------------------------------------------
    */
    
    'call' => [
        'timeout' => 30, // seconds
        'record' => true,
        'transcribe' => true,
        'max_duration' => 300, // 5 minutes
    ],
    
    /*
    |--------------------------------------------------------------------------
    | AI Integration
    |--------------------------------------------------------------------------
    */
    
    'ai' => [
        'enabled' => true,
        'model' => 'gemma:2b',
        'response_timeout' => 5, // seconds
        'max_tokens' => 100,
        'temperature' => 0.7,
    ],
];
