<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('company_name')->nullable();
            $table->text('address')->nullable();
            $table->string('contact_number')->nullable();
            $table->string('alternate_number')->nullable();
            $table->string('business_type')->nullable();
            $table->string('website')->nullable();
            $table->string('gstin')->nullable();
            $table->string('status')->default('active');
            $table->string('user_id')->unique()->nullable();
            $table->foreignId('license_id')->nullable()->constrained()->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'company_name',
                'address',
                'contact_number',
                'alternate_number',
                'business_type',
                'website',
                'gstin',
                'status',
                'user_id',
                'license_id'
            ]);
        });
    }
};