<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI Voice Agent Test</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="mb-0">🤖 AI Voice Agent Test</h3>
                    </div>
                    <div class="card-body">
                        <!-- Test Results -->
                        <div id="testResults" class="mb-4">
                            <h5>Test Results:</h5>
                            <div id="resultsContainer"></div>
                        </div>

                        <!-- Test Buttons -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <button class="btn btn-primary w-100" id="testAIConnection">
                                    <i class="fas fa-wifi"></i> Test AI Connection
                                </button>
                            </div>
                            <div class="col-md-6">
                                <button class="btn btn-success w-100" id="testVoiceService">
                                    <i class="fas fa-microphone"></i> Test Voice Service
                                </button>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <button class="btn btn-info w-100" id="testConversation">
                                    <i class="fas fa-comments"></i> Test Conversation
                                </button>
                            </div>
                            <div class="col-md-6">
                                <button class="btn btn-warning w-100" id="testSentiment">
                                    <i class="fas fa-smile"></i> Test Sentiment Analysis
                                </button>
                            </div>
                        </div>

                        <!-- Test Input -->
                        <div class="mb-3">
                            <label for="testMessage" class="form-label">Test Message:</label>
                            <textarea class="form-control" id="testMessage" rows="3" placeholder="Enter a test message for AI processing...">Hello, I'm interested in your AI voice agent service. Can you tell me more about it?</textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <button class="btn btn-primary w-100" id="sendTestMessage">
                                    <i class="fas fa-paper-plane"></i> Send Test Message
                                </button>
                            </div>
                            <div class="col-md-6">
                                <button class="btn btn-secondary w-100" id="clearResults">
                                    <i class="fas fa-trash"></i> Clear Results
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- AI Response Display -->
                <div class="card mt-4" id="aiResponseCard" style="display: none;">
                    <div class="card-header">
                        <h5 class="mb-0">AI Response</h5>
                    </div>
                    <div class="card-body">
                        <div id="aiResponse"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            setupEventListeners();
        });

        function setupEventListeners() {
            document.getElementById('testAIConnection').addEventListener('click', testAIConnection);
            document.getElementById('testVoiceService').addEventListener('click', testVoiceService);
            document.getElementById('testConversation').addEventListener('click', testConversation);
            document.getElementById('testSentiment').addEventListener('click', testSentiment);
            document.getElementById('sendTestMessage').addEventListener('click', sendTestMessage);
            document.getElementById('clearResults').addEventListener('click', clearResults);
        }

        function addResult(title, content, type = 'info') {
            const container = document.getElementById('resultsContainer');
            const alertClass = type === 'success' ? 'alert-success' : type === 'error' ? 'alert-danger' : 'alert-info';
            
            const resultDiv = document.createElement('div');
            resultDiv.className = `alert ${alertClass} alert-dismissible fade show`;
            resultDiv.innerHTML = `
                <strong>${title}</strong><br>
                <pre style="white-space: pre-wrap; margin: 0;">${JSON.stringify(content, null, 2)}</pre>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            
            container.appendChild(resultDiv);
        }

        function testAIConnection() {
            addResult('Testing AI Connection...', 'Sending request...', 'info');
            
            fetch('/user/ai/test-connection', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                addResult('AI Connection Test', data, data.success ? 'success' : 'error');
            })
            .catch(error => {
                addResult('AI Connection Test Error', error.message, 'error');
            });
        }

        function testVoiceService() {
            addResult('Testing Voice Service...', 'Sending request...', 'info');
            
            // This would test the voice service
            addResult('Voice Service Test', {
                success: true,
                message: 'Voice service test not implemented yet',
                note: 'This would test speech-to-text and text-to-speech functionality'
            }, 'info');
        }

        function testConversation() {
            addResult('Testing Conversation...', 'Sending request...', 'info');
            
            fetch('/user/ai/conversations/start', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    type: 'general',
                    context: { test: true }
                })
            })
            .then(response => response.json())
            .then(data => {
                addResult('Conversation Test', data, data.success ? 'success' : 'error');
                
                if (data.success) {
                    // Test sending a message
                    testSendMessage(data.conversation.id);
                }
            })
            .catch(error => {
                addResult('Conversation Test Error', error.message, 'error');
            });
        }

        function testSendMessage(conversationId) {
            const message = document.getElementById('testMessage').value;
            
            fetch(`/user/ai/conversations/${conversationId}/message`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    message: message,
                    metadata: { test: true }
                })
            })
            .then(response => response.json())
            .then(data => {
                addResult('Message Test', data, data.success ? 'success' : 'error');
                
                if (data.success && data.data.ai_message) {
                    document.getElementById('aiResponse').innerHTML = `
                        <div class="alert alert-info">
                            <strong>AI Response:</strong><br>
                            ${data.data.ai_message.content}
                        </div>
                    `;
                    document.getElementById('aiResponseCard').style.display = 'block';
                }
            })
            .catch(error => {
                addResult('Message Test Error', error.message, 'error');
            });
        }

        function testSentiment() {
            const message = document.getElementById('testMessage').value;
            
            addResult('Testing Sentiment Analysis...', 'Sending request...', 'info');
            
            fetch('/user/ai/analyze-sentiment', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    text: message
                })
            })
            .then(response => response.json())
            .then(data => {
                addResult('Sentiment Analysis Test', data, data.success ? 'success' : 'error');
            })
            .catch(error => {
                addResult('Sentiment Analysis Test Error', error.message, 'error');
            });
        }

        function sendTestMessage() {
            testConversation();
        }

        function clearResults() {
            document.getElementById('resultsContainer').innerHTML = '';
            document.getElementById('aiResponseCard').style.display = 'none';
        }
    </script>
</body>
</html>
<?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/test-ai.blade.php ENDPATH**/ ?>