

<?php $__env->startSection('title', 'Transaction History'); ?>

<?php $__env->startSection('content'); ?>
<div class="wallet-transactions">
    <!-- Header -->
    <div class="wallet-header mb-4">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2 class="wallet-title">Transaction History</h2>
                <p class="wallet-subtitle">View all your wallet transactions</p>
            </div>
            <div class="wallet-actions">
                <a href="<?php echo e(route('user.wallet.index')); ?>" class="btn btn-outline-primary">
                    <i class="fas fa-arrow-left"></i> Back to Wallet
                </a>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <form id="filterForm" class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Transaction Type</label>
                            <select class="form-select" name="type">
                                <option value="">All Types</option>
                                <option value="credit">Credit</option>
                                <option value="debit">Debit</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="">All Status</option>
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">From Date</label>
                            <input type="date" class="form-control" name="from_date">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">To Date</label>
                            <input type="date" class="form-control" name="to_date">
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-filter"></i> Apply Filters
                            </button>
                            <button type="button" class="btn btn-outline-secondary" onclick="clearFilters()">
                                <i class="fas fa-times"></i> Clear
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title">All Transactions</h5>
                    <div class="d-flex align-items-center">
                        <span class="text-muted me-3">Total: <?php echo e($transactions->total()); ?> transactions</span>
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="exportTransactions('csv')">
                                <i class="fas fa-file-csv"></i> CSV
                            </button>
                            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="exportTransactions('pdf')">
                                <i class="fas fa-file-pdf"></i> PDF
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <?php if($transactions->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Transaction ID</th>
                                        <th>Type</th>
                                        <th>Description</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Payment Method</th>
                                        <th>Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <code class="text-primary"><?php echo e($transaction->reference_id); ?></code>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?php echo e($transaction->type === 'credit' ? 'success' : 'danger'); ?>">
                                                <i class="fas <?php echo e($transaction->type === 'credit' ? 'fa-arrow-down' : 'fa-arrow-up'); ?>"></i>
                                                <?php echo e(ucfirst($transaction->type)); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($transaction->description); ?></td>
                                        <td>
                                            <span class="fw-bold <?php echo e($transaction->type === 'credit' ? 'text-success' : 'text-danger'); ?>">
                                                <?php echo e($transaction->type === 'credit' ? '+' : '-'); ?>₹<?php echo e(number_format($transaction->amount, 2)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge status-<?php echo e($transaction->status); ?>">
                                                <?php echo e(ucfirst($transaction->status)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <i class="fas <?php echo e($transaction->payment_method === 'razorpay' ? 'fa-credit-card' : ($transaction->payment_method === 'stripe' ? 'fab fa-stripe' : ($transaction->payment_method === 'paypal' ? 'fab fa-paypal' : 'fas fa-university'))); ?>"></i>
                                            <?php echo e(ucfirst($transaction->payment_method ?? 'N/A')); ?>

                                        </td>
                                        <td>
                                            <div class="d-flex flex-column">
                                                <span><?php echo e($transaction->created_at->format('M d, Y')); ?></span>
                                                <small class="text-muted"><?php echo e($transaction->created_at->format('h:i A')); ?></small>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <button class="btn btn-outline-primary" onclick="viewTransaction(<?php echo e($transaction->id); ?>)">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                <?php if($transaction->status === 'pending'): ?>
                                                <button class="btn btn-outline-warning" onclick="cancelTransaction(<?php echo e($transaction->id); ?>)">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center mt-4">
                            <?php echo e($transactions->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="empty-state text-center py-5">
                            <i class="fas fa-receipt fa-3x text-muted mb-3"></i>
                            <h5>No transactions found</h5>
                            <p class="text-muted">Your transaction history will appear here once you start using your wallet.</p>
                            <a href="<?php echo e(route('user.wallet.index')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Add Funds
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Transaction Details Modal -->
<div class="modal fade" id="transactionModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Transaction Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="transactionDetails">
                <!-- Transaction details will be loaded here -->
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
// Filter form submission
document.getElementById('filterForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const formData = new FormData(this);
    const params = new URLSearchParams();
    
    for (let [key, value] of formData.entries()) {
        if (value) params.append(key, value);
    }
    
    window.location.href = '<?php echo e(route("user.wallet.transactions")); ?>?' + params.toString();
});

// Clear filters
function clearFilters() {
    document.getElementById('filterForm').reset();
    window.location.href = '<?php echo e(route("user.wallet.transactions")); ?>';
}

// View transaction details
function viewTransaction(transactionId) {
    // Simulate loading transaction details
    const modal = new bootstrap.Modal(document.getElementById('transactionModal'));
    document.getElementById('transactionDetails').innerHTML = `
        <div class="text-center py-4">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <p class="mt-2">Loading transaction details...</p>
        </div>
    `;
    modal.show();
    
    // Simulate API call
    setTimeout(() => {
        document.getElementById('transactionDetails').innerHTML = `
            <div class="transaction-details">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Transaction ID:</strong>
                        <p class="text-muted">TXN_1234567890_1</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Status:</strong>
                        <span class="badge bg-success">Completed</span>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Amount:</strong>
                        <p class="text-success fw-bold">+₹1,000.00</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Type:</strong>
                        <p>Credit</p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Payment Method:</strong>
                        <p>Razorpay</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Date:</strong>
                        <p>Dec 15, 2024 2:30 PM</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <strong>Description:</strong>
                        <p>Wallet Top-up via Razorpay</p>
                    </div>
                </div>
            </div>
        `;
    }, 1000);
}

// Cancel transaction
function cancelTransaction(transactionId) {
    if (confirm('Are you sure you want to cancel this transaction?')) {
        // Simulate API call
        showNotification('success', 'Transaction cancelled successfully');
        location.reload();
    }
}

// Export transactions
function exportTransactions(format) {
    showNotification('info', `Exporting transactions as ${format.toUpperCase()}...`);
    // Implement export functionality
}

// Show notification
function showNotification(type, message) {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : type === 'error' ? 'danger' : 'info'} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.remove();
    }, 5000);
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    console.log('Transaction history loaded successfully!');
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('FrontUser.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/FrontUser/wallet/transactions.blade.php ENDPATH**/ ?>