@extends('FrontUser.layouts.app')

@section('title', 'Account Settings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Account Settings</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Profile Settings</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="{{ route('user.settings.profile.update') }}" enctype="multipart/form-data">
                                        @csrf
                                        <div class="mb-3">
                                            <label for="avatar" class="form-label">Profile Picture</label>
                                            <input class="form-control" type="file" id="avatar" name="avatar">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Full Name</label>
                                            <input type="text" class="form-control" name="name" value="{{ old('name', $user->name) }}">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Email Address</label>
                                            <input type="email" class="form-control" name="email" value="{{ old('email', $user->email) }}">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Phone Number</label>
                                            <input type="text" class="form-control" name="contact_number" value="{{ old('contact_number', $user->contact_number) }}">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Company Name</label>
                                            <input type="text" class="form-control" name="company_name" value="{{ old('company_name', $user->company_name) }}">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Theme</label>
                                            <select class="form-select" name="theme">
                                                <option value="light" {{ old('theme', $user->theme) === 'light' ? 'selected' : '' }}>Light</option>
                                                <option value="dark" {{ old('theme', $user->theme) === 'dark' ? 'selected' : '' }}>Dark</option>
                                            </select>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Address</label>
                                            <textarea class="form-control" name="address">{{ old('address', $user->address) }}</textarea>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Website</label>
                                            <input type="url" class="form-control" name="website" value="{{ old('website', $user->website) }}">
                                        </div>
                                        <button type="submit" class="btn btn-primary">Update Profile</button>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Security Settings</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="{{ route('user.profile.password') }}">
                                        @csrf
                                        <div class="mb-3">
                                            <label class="form-label">Current Password</label>
                                            <input type="password" class="form-control" name="current_password" placeholder="Enter current password">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">New Password</label>
                                            <input type="password" class="form-control" name="new_password" placeholder="Enter new password">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Confirm New Password</label>
                                            <input type="password" class="form-control" name="new_password_confirmation" placeholder="Confirm new password">
                                        </div>
                                        <button type="submit" class="btn btn-primary">Change Password</button>
                                    </form>
                                </div>
                            </div>

                            <div class="card mt-4">
                                <div class="card-header">
                                    <h5>Notification Preferences</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="{{ route('user.settings.notifications.update') }}">
                                        @csrf
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" name="email" id="emailNotifications" {{ old('email', true) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="emailNotifications">Email Notifications</label>
                                        </div>
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" name="sms" id="smsNotifications">
                                            <label class="form-check-label" for="smsNotifications">SMS Notifications</label>
                                        </div>
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" name="low_balance" id="lowBalanceAlert" {{ old('low_balance', true) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="lowBalanceAlert">Low Balance Alerts</label>
                                        </div>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" name="weekly_reports" id="callReports" {{ old('weekly_reports', true) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="callReports">Weekly Call Reports</label>
                                        </div>
                                        <button type="submit" class="btn btn-primary mt-3">Save Preferences</button>
                                    </form>
                                        <label class="form-check-label" for="emailNotifications">Email Notifications</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" type="checkbox" id="smsNotifications">
                                        <label class="form-check-label" for="smsNotifications">SMS Notifications</label>
                                    </div>
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" type="checkbox" id="lowBalanceAlert" checked>
                                        <label class="form-check-label" for="lowBalanceAlert">Low Balance Alerts</label>
                                    </div>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="callReports" checked>
                                        <label class="form-check-label" for="callReports">Weekly Call Reports</label>
                                    </div>
                                    <button type="submit" class="btn btn-primary mt-3">Save Preferences</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5>API Settings</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="{{ route('user.settings.api.update') }}">
                                        @csrf
                                        <div class="mb-3">
                                            <label class="form-label">Webhook URL</label>
                                            <input type="url" class="form-control" name="webhook_url" placeholder="https://example.com/webhook" value="{{ old('webhook_url') }}">
                                        </div>
                                        <button type="submit" class="btn btn-primary">Save API Settings</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection