@extends('layouts.admin')

@section('content')
<div class="container">
    <h1>{{ $ticket->subject }}</h1>
    <p><strong>User:</strong> {{ $ticket->user->name }}</p>
    <p><strong>Status:</strong> {{ $ticket->status }}</p>

    <div class="card">
        <div class="card-body">
            <p>{{ $ticket->message }}</p>
            @if($ticket->image_path)
            <img src="{{ asset('storage/' . $ticket->image_path) }}" alt="Ticket Image" style="max-width: 100%;">
            @endif
        </div>
        <div class="card-footer text-muted">
            {{ $ticket->created_at->diffForHumans() }}
        </div>
    </div>

    <hr>

    <h3>Replies</h3>

    @foreach($ticket->replies as $reply)
    <div class="card mt-3">
        <div class="card-body">
            <p>{{ $reply->message }}</p>
            @if($reply->image_path)
            <img src="{{ asset('storage/' . $reply->image_path) }}" alt="Reply Image" style="max-width: 100%;">
            @endif
        </div>
        <div class="card-footer text-muted">
            <strong>{{ $reply->user->name }}</strong> replied {{ $reply->created_at->diffForHumans() }}
        </div>
    </div>
    @endforeach

    <hr>

    @if($ticket->status !== 'closed')
    <h3>Reply to Ticket</h3>
    <form action="{{ route('admin.tickets.reply', $ticket) }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="form-group">
            <label for="message">Your Reply</label>
            <textarea name="message" id="message" class="form-control" rows="5" required></textarea>
        </div>
        <div class="form-group mt-3">
            <label for="image">Image (optional)</label>
            <input type="file" name="image" id="image" class="form-control">
        </div>
        <button type="submit" class="btn btn-primary mt-3">Send Reply</button>
    </form>

    <hr>

    <form action="{{ route('admin.tickets.close', $ticket) }}" method="POST">
        @csrf
        <button type="submit" class="btn btn-danger">Close Ticket</button>
    </form>
    @else
    <div class="alert alert-info">This ticket is closed.</div>
    @endif

</div>
@endsection
