<?php

echo "Testing Ollama connection...\n";

$url = 'http://localhost:11434/api/generate';
$data = [
    'model' => 'gemma:2b',
    'prompt' => 'Hello, are you working?',
    'stream' => false
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n";

if ($httpCode === 200) {
    $result = json_decode($response, true);
    echo "AI Response: " . ($result['response'] ?? 'No response') . "\n";
    echo "✅ Ollama is working!\n";
} else {
    echo "❌ Ollama connection failed\n";
}
