

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Dashboard'); ?> - DizzCall AI</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #4895ef;
            --secondary: #3a0ca3;
            --secondary-light: #7209b7;
            --accent: #f72585;
            --light: #f8f9fa;
            --dark: #212529;
            --gray: #6c757d;
            --light-gray: #e9ecef;
            --success: #4cc9f0;
            --warning: #f8961e;
            --danger: #f94144;
            --info: #4895ef;
            --sidebar-width: 250px;
            --sidebar-collapsed-width: 70px;
            --transition-speed: 0.3s;
            --card-border-radius: 16px;
            --element-border-radius: 12px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: #f5f7fa;
            color: var(--dark);
            overflow-x: hidden;
        }

        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            background: linear-gradient(180deg, var(--primary) 0%, var(--primary-light) 100%);
            color: white;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            transition: all var(--transition-speed) ease;
            box-shadow: 2px 0 15px rgba(0, 0, 0, 0.1);
        }

        .sidebar.collapsed {
            width: var(--sidebar-collapsed-width);
        }

        .logo-container {
            padding: 20px 15px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .logo-text {
            font-size: 20px;
            font-weight: 700;
            white-space: nowrap;
            overflow: hidden;
            transition: opacity var(--transition-speed);
        }

        .sidebar.collapsed .logo-text {
            opacity: 0;
            width: 0;
        }

        .toggle-btn {
            background: transparent;
            border: none;
            color: white;
            cursor: pointer;
            font-size: 20px;
            transition: transform var(--transition-speed);
            padding: 5px;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .toggle-btn:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .sidebar.collapsed .toggle-btn {
            transform: rotate(180deg);
        }

        .nav-menu {
            list-style: none;
            padding: 20px 0;
            margin: 0;
        }

        .nav-item {
            margin-bottom: 5px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: all 0.3s ease;
            border-left: 3px solid transparent;
            white-space: nowrap;
            position: relative;
            overflow: hidden;
        }

        .nav-link:before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }

        .nav-link:hover:before {
            left: 100%;
        }

        .nav-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
            padding-left: 25px;
        }

        .nav-link.active {
            background-color: rgba(255, 255, 255, 0.15);
            color: white;
            border-left: 3px solid white;
        }

        .nav-icon {
            margin-right: 15px;
            width: 20px;
            text-align: center;
            font-size: 18px;
            transition: margin var(--transition-speed);
        }

        .sidebar.collapsed .nav-icon {
            margin-right: 0;
        }

        .nav-text {
            flex: 1;
            transition: opacity var(--transition-speed);
            opacity: 1;
        }

        .sidebar.collapsed .nav-text {
            opacity: 0;
            width: 0;
            height: 0;
            overflow: hidden;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            padding: 20px 30px;
            margin-left: var(--sidebar-width);
            transition: margin-left var(--transition-speed);
        }

        .main-content.expanded {
            margin-left: var(--sidebar-collapsed-width);
        }

        /* Header */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            background-color: white;
            padding: 18px 30px;
            border-radius: var(--card-border-radius);
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }

        .header:hover {
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }

        .page-title h1 {
            margin: 0;
            font-size: 26px;
            font-weight: 700;
            color: var(--dark);
            background: linear-gradient(90deg, var(--primary), var(--accent));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .user-actions {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .search-bar {
            position: relative;
            display: flex;
            align-items: center;
        }

        .search-bar i {
            position: absolute;
            left: 15px;
            color: var(--gray);
            z-index: 1;
        }

        .search-bar input {
            padding: 12px 15px 12px 45px;
            border: 1px solid var(--light-gray);
            border-radius: 30px;
            width: 220px;
            transition: all 0.3s ease;
            background-color: #f8f9fa;
            font-size: 14px;
        }

        .search-bar input:focus {
            width: 280px;
            border-color: var(--primary-light);
            outline: none;
            box-shadow: 0 0 0 4px rgba(67, 97, 238, 0.1);
            background-color: white;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 12px;
            cursor: pointer;
            padding: 8px 15px;
            border-radius: 30px;
            transition: all 0.3s ease;
        }

        .user-profile:hover {
            background-color: #f0f2f5;
        }

        .user-profile img {
            width: 42px;
            height: 42px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--primary-light);
            transition: all 0.3s ease;
        }

        .user-profile:hover img {
            border-color: var(--primary);
            transform: scale(1.05);
        }

        .user-info h4 {
            margin: 0;
            font-size: 15px;
            font-weight: 600;
        }

        .user-info p {
            margin: 0;
            font-size: 13px;
            color: var(--gray);
        }

        .btn-logout {
            background-color: transparent;
            border: 1px solid var(--danger);
            color: var(--danger);
            padding: 10px 18px;
            border-radius: 30px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-logout:hover {
            background-color: var(--danger);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(249, 65, 68, 0.3);
        }

        /* Dashboard Content */
        .wallet-balance {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            border-radius: var(--card-border-radius);
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            margin-bottom: 25px;
            color: white;
            position: relative;
            overflow: hidden;
            transition: all 0.4s ease;
        }

        .wallet-balance:before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: rgba(255, 255, 255, 0.1);
            transform: rotate(15deg);
            transition: all 0.5s ease;
        }

        .wallet-balance:hover:before {
            transform: rotate(25deg) translateX(20px);
        }

        .wallet-balance:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
        }

        .balance-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            position: relative;
            z-index: 1;
        }

        .balance-title {
            font-size: 20px;
            font-weight: 600;
            margin: 0;
            color: rgba(255, 255, 255, 0.95);
        }

        .badge {
            padding: 6px 14px;
            border-radius: 30px;
            font-size: 13px;
            font-weight: 600;
            background-color: rgba(255, 255, 255, 0.25);
            color: white;
            backdrop-filter: blur(5px);
        }

        .balance-amount {
            font-size: 38px;
            font-weight: 800;
            margin: 0 0 12px;
            position: relative;
            z-index: 1;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        }

        .balance-info {
            font-size: 15px;
            color: rgba(255, 255, 255, 0.85);
            margin: 0 0 25px;
            position: relative;
            z-index: 1;
        }

        .recharge-btn {
            background-color: white;
            color: var(--primary);
            border: none;
            padding: 14px 20px;
            border-radius: var(--element-border-radius);
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 10px;
            width: 100%;
            justify-content: center;
            position: relative;
            z-index: 1;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .recharge-btn:hover {
            background-color: var(--light);
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }

        /* Stats Cards */
        .stat-card {
            background-color: white;
            border-radius: var(--card-border-radius);
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            text-align: center;
            transition: all 0.3s ease;
            height: 100%;
            position: relative;
            overflow: hidden;
        }

        .stat-card:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 5px;
            height: 100%;
            background: linear-gradient(to bottom, var(--primary), var(--primary-light));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .stat-card:hover:before {
            opacity: 1;
        }

        .stat-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 25px rgba(0, 0, 0, 0.1);
        }

        .stat-icon {
            font-size: 26px;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            transition: all 0.3s ease;
        }

        .stat-card:hover .stat-icon {
            transform: scale(1.1);
        }

        .calls-icon {
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary);
        }

        .duration-icon {
            background-color: rgba(76, 201, 240, 0.1);
            color: var(--success);
        }

        .money-icon {
            background-color: rgba(247, 37, 133, 0.1);
            color: var(--accent);
        }

        .stat-title {
            font-size: 15px;
            color: var(--gray);
            margin-bottom: 10px;
            font-weight: 500;
        }

        .stat-value {
            font-size: 28px;
            font-weight: 800;
            color: var(--dark);
            transition: all 0.3s ease;
        }

        .stat-card:hover .stat-value {
            color: var(--primary);
        }

        /* Tables */
        .table-container {
            background-color: white;
            border-radius: var(--card-border-radius);
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            margin-bottom: 30px;
            transition: all 0.3s ease;
        }

        .table-container:hover {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
        }

        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }

        .table-title {
            font-size: 20px;
            font-weight: 700;
            margin: 0;
            color: var(--dark);
            background: linear-gradient(90deg, var(--dark), var(--gray));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            border: none;
            padding: 10px 20px;
            border-radius: 30px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(67, 97, 238, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(67, 97, 238, 0.4);
            background: linear-gradient(135deg, var(--primary-light) 0%, var(--primary) 100%);
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th {
            text-align: left;
            padding: 15px;
            background-color: var(--light);
            color: var(--gray);
            font-weight: 600;
            font-size: 14px;
            border-bottom: 2px solid var(--light-gray);
        }

        td {
            padding: 15px;
            border-bottom: 1px solid var(--light-gray);
            font-size: 14px;
            transition: all 0.2s ease;
        }

        tr:last-child td {
            border-bottom: none;
        }

        tr:hover td {
            background-color: rgba(67, 97, 238, 0.05);
            transform: scale(1.01);
        }

        .status {
            display: inline-block;
            padding: 7px 14px;
            border-radius: 30px;
            font-size: 12px;
            font-weight: 600;
        }

        .status.active {
            background-color: rgba(76, 201, 240, 0.2);
            color: var(--success);
        }

        .status.pending {
            background-color: rgba(248, 150, 30, 0.2);
            color: var(--warning);
        }

        .status.completed {
            background-color: rgba(67, 97, 238, 0.2);
            color: var(--primary);
        }

        .status.failed {
            background-color: rgba(249, 65, 68, 0.2);
            color: var(--danger);
        }

        .action-btn {
            background-color: transparent;
            border: 1px solid var(--light-gray);
            color: var(--gray);
            width: 35px;
            height: 35px;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-right: 8px;
        }

        .action-btn:hover {
            background-color: var(--light);
            color: var(--primary);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .action-btn.danger:hover {
            color: var(--danger);
            border-color: var(--danger);
        }

        /* New Activity Section */
        .activity-container {
            background-color: white;
            border-radius: var(--card-border-radius);
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            margin-bottom: 30px;
            transition: all 0.3s ease;
        }

        .activity-container:hover {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
        }

        .activity-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .activity-item {
            display: flex;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid var(--light-gray);
            transition: all 0.3s ease;
        }

        .activity-item:last-child {
            border-bottom: none;
        }

        .activity-item:hover {
            background-color: #fafbff;
            padding-left: 10px;
        }

        .activity-icon {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-size: 18px;
            color: white;
        }

        .call-activity {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
        }

        .recharge-activity {
            background: linear-gradient(135deg, var(--success) 0%, #4cc9f0 100%);
        }

        .system-activity {
            background: linear-gradient(135deg, var(--accent) 0%, #f72585 100%);
        }

        .activity-content {
            flex: 1;
        }

        .activity-content h4 {
            margin: 0;
            font-size: 15px;
            font-weight: 600;
            color: var(--dark);
        }

        .activity-content p {
            margin: 5px 0 0;
            font-size: 13px;
            color: var(--gray);
        }

        .activity-time {
            font-size: 12px;
            color: var(--gray);
            margin-left: 15px;
        }

        /* Responsive */
        @media (max-width: 992px) {
            .sidebar {
                left: -var(--sidebar-width);
            }
            
            .sidebar.mobile-show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0;
                padding: 15px;
            }
            
            .main-content.expanded {
                margin-left: 0;
            }
            
            .header {
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }
            
            .user-actions {
                width: 100%;
                justify-content: space-between;
            }
            
            .search-bar input {
                width: 150px;
            }
            
            .search-bar input:focus {
                width: 200px;
            }
            
            .mobile-toggle {
                display: block !important;
            }
        }

        .mobile-toggle {
            display: none;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            color: white;
            border: none;
            border-radius: var(--element-border-radius);
            padding: 10px 15px;
            margin-bottom: 20px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .mobile-toggle:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .animate-fadeIn {
            animation: fadeIn 0.6s ease forwards;
        }

        /* Loading spinner */
        .spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid var(--primary);
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 1s linear infinite;
            display: inline-block;
            margin-right: 10px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Footer */
        .footer {
            text-align: center;
            padding: 20px;
            color: var(--gray);
            font-size: 14px;
            margin-top: 30px;
        }

        .footer a {
            color: var(--primary);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer a:hover {
            color: var(--primary-light);
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <!-- Dashboard Container -->
    <div class="dashboard-container">
        <!-- Sidebar -->
        <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Header -->
            <?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            
            <!-- Dashboard Content -->
            <?php echo $__env->yieldContent('content'); ?>
            
            <!-- Footer -->
            <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </main>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Toggle sidebar
            const toggleBtn = document.querySelector('.toggle-btn');
            const sidebar = document.querySelector('.sidebar');
            const mainContent = document.querySelector('.main-content');
            const mobileToggle = document.querySelector('.mobile-toggle');
            
            toggleBtn.addEventListener('click', function() {
                sidebar.classList.toggle('collapsed');
                mainContent.classList.toggle('expanded');
            });
            
            mobileToggle.addEventListener('click', function() {
                sidebar.classList.toggle('mobile-show');
            });
            
            // Sample data for demonstration
            document.getElementById('today-total-calls').textContent = '12';
            document.getElementById('today-total-duration').textContent = '38:24';
            document.getElementById('today-total-money').textContent = '₹94.50';
            
            // Add animation to elements
            const animateElements = document.querySelectorAll('.stat-card, .table-container, .wallet-balance');
            animateElements.forEach((element, index) => {
                element.style.animationDelay = `${index * 0.1}s`;
                element.classList.add('animate-fadeIn');
            });
            
            // Format date to display
            function formatDisplayDate(dateString) {
                const date = new Date(dateString);
                return date.toLocaleString('en-US', {
                    year: 'numeric',
                    month: 'short',
                    day: 'numeric',
                    hour: '2-digit',
                    minute: '2-digit'
                });
            }

            // Format duration (seconds to MM:SS)
            function formatDuration(seconds) {
                const mins = Math.floor(seconds / 60);
                const secs = seconds % 60;
                return `${mins.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
            }

            // Format currency
            function formatCurrency(amount) {
                return '₹' + amount.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            }
        });
    </script>
    
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html><?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/layouts/app.blade.php ENDPATH**/ ?>