<?php $__env->startSection('title', 'User Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid p-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
            <p class="text-muted">Welcome back, <?php echo e(Auth::user()->name); ?>!</p>
        </div>
    </div>

    <div class="row">
        <!-- Wallet Balance -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Wallet Balance</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹ <?php echo e(number_format($walletBalance ?? 0, 2)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-wallet fa-2x text-gray-300"></i>
                        </div>
                    </div>
                    <a href="<?php echo e(route('wallet.topup')); ?>" class="btn btn-primary btn-sm mt-3">
                        <i class="fas fa-plus-circle fa-sm"></i> Recharge Wallet
                    </a>
                </div>
            </div>
        </div>

        <!-- Total Calls -->
        <div class="col-xl-2 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Total Calls</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($totalCalls ?? 0); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-phone fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Duration -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Duration
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(sprintf('%02d:%02d', floor(($totalDurationSeconds ?? 0)/60), ($totalDurationSeconds ?? 0)%60)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Money Used -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Money Used</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹ <?php echo e(number_format($totalMoney ?? 0, 2)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts -->
    <div class="row">
        <div class="col-lg-8 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Calls & Duration (Last 7 days)</h6>
                </div>
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="callsChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Spend (Last 7 days)</h6>
                </div>
                <div class="card-body">
                    <div class="chart-bar">
                        <canvas id="spendChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent & Scheduled Calls -->
    <div class="row">
        <div class="col-lg-12 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Recent Calls</h6>
                    <a href="#" class="btn btn-sm btn-primary shadow-sm"><i class="fas fa-list fa-sm text-white-50"></i> View All Calls</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Call ID</th>
                                    <th>Contact Name</th>
                                    <th>Contact No.</th>
                                    <th>Date/Time</th>
                                    <th>Duration</th>
                                    <th>Cost</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = ($recentCalls ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $call): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(data_get($call, 'call_id') ?? data_get($call, 'id')); ?></td>
                                    <td><?php echo e(data_get($call, 'contact_name') ?? '—'); ?></td>
                                    <td><?php echo e(data_get($call, 'phone_number') ?? '—'); ?></td>
                                    <?php ($dt = data_get($call, 'date_time')); ?>
                                    <td><?php echo e($dt ? \Illuminate\Support\Carbon::parse($dt)->format('M d, Y h:i A') : '—'); ?></td>
                                    <?php ($dur = (int) (data_get($call, 'duration') ?? 0)); ?>
                                    <td><?php echo e(sprintf('%02d:%02d', floor($dur/60), $dur%60)); ?></td>
                                    <?php ($cost = (float) (data_get($call, 'cost') ?? 0)); ?>
                                    <td>₹ <?php echo e(number_format($cost, 2)); ?></td>
                                    <?php ($status = data_get($call, 'status', 'active')); ?>
                                    <td>
                                        <span class="badge badge-<?php echo e($status === 'completed' ? 'success' : ($status === 'pending' ? 'warning' : 'primary')); ?>">
                                            <?php echo e(ucfirst($status)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <a href="#" class="btn btn-info btn-circle btn-sm" title="View Transcript"><i class="fas fa-file-alt"></i></a>
                                        <a href="#" class="btn btn-secondary btn-circle btn-sm" title="View Summary"><i class="fas fa-list"></i></a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center">No recent calls.</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-12 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Scheduled Calls</h6>
                    <a href="#" class="btn btn-sm btn-primary shadow-sm"><i class="fas fa-plus fa-sm text-white-50"></i> Schedule New Call</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="scheduledCallsTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Call ID</th>
                                    <th>Contact</th>
                                    <th>Scheduled Date/Time</th>
                                    <th>Purpose</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = ($scheduledCalls ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $call): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(data_get($call, 'call_id') ?? data_get($call, 'id')); ?></td>
                                    <td><?php echo e(data_get($call, 'contact_name') ?? '—'); ?></td>
                                    <?php ($sdt = data_get($call, 'date_time')); ?>
                                    <td><?php echo e($sdt ? \Illuminate\Support\Carbon::parse($sdt)->format('M d, Y h:i A') : '—'); ?></td>
                                    <td><?php echo e(data_get($call, 'purpose') ?? '—'); ?></td>
                                    <td><span class="badge badge-warning">Pending</span></td>
                                    <td>
                                        <a href="#" class="btn btn-warning btn-circle btn-sm" title="Edit"><i class="fas fa-edit"></i></a>
                                        <a href="#" class="btn btn-danger btn-circle btn-sm" title="Cancel"><i class="fas fa-times"></i></a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">No scheduled calls.</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Common Chart.js options
            Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
            Chart.defaults.global.defaultFontColor = '#858796';

            function number_format(number, decimals, dec_point, thousands_sep) {
                // ... (rest of the function from startbootstrap-sb-admin-2)
                return '₹' + number.toFixed(decimals);
            }

            // Calls Chart
            const callsCtx = document.getElementById('callsChart');
            if (callsCtx) {
                new Chart(callsCtx, {
                    type: 'line',
                    data: {
                        labels: <?php echo json_encode($chartLabels ?? [], 15, 512) ?>,
                        datasets: [{
                            label: "Calls",
                            lineTension: 0.3,
                            backgroundColor: "rgba(78, 115, 223, 0.05)",
                            borderColor: "rgba(78, 115, 223, 1)",
                            pointRadius: 3,
                            pointBackgroundColor: "rgba(78, 115, 223, 1)",
                            pointBorderColor: "rgba(78, 115, 223, 1)",
                            pointHoverRadius: 3,
                            pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                            pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                            pointHitRadius: 10,
                            pointBorderWidth: 2,
                            data: <?php echo json_encode($chartCalls ?? [], 15, 512) ?>,
                        },
                        {
                            label: "Duration (mins)",
                            lineTension: 0.3,
                            backgroundColor: "rgba(28, 200, 138, 0.05)",
                            borderColor: "rgba(28, 200, 138, 1)",
                            pointRadius: 3,
                            pointBackgroundColor: "rgba(28, 200, 138, 1)",
                            pointBorderColor: "rgba(28, 200, 138, 1)",
                            pointHoverRadius: 3,
                            pointHoverBackgroundColor: "rgba(28, 200, 138, 1)",
                            pointHoverBorderColor: "rgba(28, 200, 138, 1)",
                            pointHitRadius: 10,
                            pointBorderWidth: 2,
                            data: <?php echo json_encode($chartDurationMinutes ?? [], 15, 512) ?>,
                        }],
                    },
                    options: {
                        maintainAspectRatio: false,
                        layout: {
                            padding: {
                                left: 10,
                                right: 25,
                                top: 25,
                                bottom: 0
                            }
                        },
                        scales: {
                            xAxes: [{
                                time: {
                                    unit: 'date'
                                },
                                gridLines: {
                                    display: false,
                                    drawBorder: false
                                },
                                ticks: {
                                    maxTicksLimit: 7
                                }
                            }],
                            yAxes: [{
                                ticks: {
                                    maxTicksLimit: 5,
                                    padding: 10,
                                },
                                gridLines: {
                                    color: "rgb(234, 236, 244)",
                                    zeroLineColor: "rgb(234, 236, 244)",
                                    drawBorder: false,
                                    borderDash: [2],
                                    zeroLineBorderDash: [2]
                                }
                            }],
                        },
                        legend: {
                            display: true,
                            position: 'bottom'
                        },
                        tooltips: {
                            backgroundColor: "rgb(255,255,255)",
                            bodyFontColor: "#858796",
                            titleMarginBottom: 10,
                            titleFontColor: '#6e707e',
                            titleFontSize: 14,
                            borderColor: '#dddfeb',
                            borderWidth: 1,
                            xPadding: 15,
                            yPadding: 15,
                            displayColors: false,
                            intersect: false,
                            mode: 'index',
                            caretPadding: 10,
                        }
                    }
                });
            }

            // Spend Chart
            const spendCtx = document.getElementById('spendChart');
            if (spendCtx) {
                new Chart(spendCtx, {
                    type: 'bar',
                    data: {
                        labels: <?php echo json_encode($chartLabels ?? [], 15, 512) ?>,
                        datasets: [{
                            label: "Spend",
                            backgroundColor: "#f6c23e",
                            hoverBackgroundColor: "#f4b619",
                            borderColor: "#f6c23e",
                            data: <?php echo json_encode($chartSpend ?? [], 15, 512) ?>,
                        }],
                    },
                    options: {
                        maintainAspectRatio: false,
                        layout: {
                            padding: {
                                left: 10,
                                right: 25,
                                top: 25,
                                bottom: 0
                            }
                        },
                        scales: {
                            xAxes: [{
                                time: {
                                    unit: 'date'
                                },
                                gridLines: {
                                    display: false,
                                    drawBorder: false
                                },
                                ticks: {
                                    maxTicksLimit: 7
                                }
                            }],
                            yAxes: [{
                                ticks: {
                                    maxTicksLimit: 5,
                                    padding: 10,
                                    callback: function(value, index, values) {
                                        return '₹' + value;
                                    }
                                },
                                gridLines: {
                                    color: "rgb(234, 236, 244)",
                                    zeroLineColor: "rgb(234, 236, 244)",
                                    drawBorder: false,
                                    borderDash: [2],
                                    zeroLineBorderDash: [2]
                                }
                            }],
                        },
                        legend: {
                            display: false
                        },
                        tooltips: {
                            titleMarginBottom: 10,
                            titleFontColor: '#6e707e',
                            titleFontSize: 14,
                            backgroundColor: "rgb(255,255,255)",
                            bodyFontColor: "#858796",
                            borderColor: '#dddfeb',
                            borderWidth: 1,
                            xPadding: 15,
                            yPadding: 15,
                            displayColors: false,
                            caretPadding: 10,
                            callbacks: {
                                label: function(tooltipItem, chart) {
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ': ₹' + tooltipItem.yLabel;
                                }
                            }
                        },
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('FrontUser.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcallcrm\resources\views/FrontUser/home.blade.php ENDPATH**/ ?>