

<?php $__env->startSection('title', 'Reports & Analytics'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Call Reports & Analytics</h3>
                    <div class="card-tools">
                        <button class="btn btn-primary">
                            <i class="fas fa-download"></i> Export Report
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Total Calls</h5>
                                    <h2><?php echo e(number_format($totalCalls ?? 0)); ?></h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Successful Calls</h5>
                                    <h2><?php echo e(number_format($successfulCalls ?? 0)); ?></h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Total Duration</h5>
                                    <?php ($mins = (int) floor(($totalDurationSeconds ?? 0)/60)); ?>
                                    <h2><?php echo e($mins); ?>m</h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Total Cost</h5>
                                    <h2>₹<?php echo e(number_format($totalCost ?? 0, 2)); ?></h2>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Call Volume (Last 30 Days)</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="volumeChart" height="120"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Call Distribution</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="distributionChart" height="120"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h5>Call History</h5>
                            <div class="card-tools">
                                <div class="input-group input-group-sm" style="width: 200px;">
                                    <input type="text" name="table_search" class="form-control float-right" placeholder="Search">
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-default">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Call ID</th>
                                            <th>From</th>
                                            <th>To</th>
                                            <th>Duration</th>
                                            <th>Status</th>
                                            <th>Cost</th>
                                            <th>Date/Time</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $calls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $call): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($call->call_id ?? $call->id); ?></td>
                                            <td><?php echo e($call->from ?? '—'); ?></td>
                                            <td><?php echo e($call->phone_number ?? $call->to ?? '—'); ?></td>
                                            <?php ($dur = (int) ($call->duration ?? 0)); ?>
                                            <td><?php echo e(sprintf('%02d:%02d', floor($dur/60), $dur%60)); ?></td>
                                            <td><span class="badge <?php echo e(($call->status==='completed') ? 'bg-success' : (($call->status==='failed')?'bg-danger':'bg-secondary')); ?>"><?php echo e(ucfirst($call->status ?? 'pending')); ?></span></td>
                                            <td>₹<?php echo e(number_format((float)($call->cost ?? 0), 2)); ?></td>
                                            <td><?php echo e(optional($call->date_time)->format('d M, h:i A')); ?></td>
                                            <td>
                                                <a class="btn btn-sm btn-info" title="View Details"><i class="fas fa-eye"></i></a>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="8" class="text-center text-muted">No calls found.</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="card-footer clearfix">
                            <?php echo e($calls->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const labels = <?php echo json_encode($labels30 ?? [], 15, 512) ?>;
    const calls = <?php echo json_encode($calls30 ?? [], 15, 512) ?>;
    const spend = <?php echo json_encode($spend30 ?? [], 15, 512) ?>;
    const statusCounts = <?php echo json_encode($statusCounts ?? [], 15, 512) ?>;

    if (window.Chart) {
        const volumeCtx = document.getElementById('volumeChart');
        if (volumeCtx) {
            new Chart(volumeCtx, {
                type: 'line',
                data: { labels, datasets: [
                    { label: 'Calls', data: calls, borderColor: '#4361ee', backgroundColor: 'rgba(67,97,238,0.2)', fill: true },
                    { label: 'Spend (₹)', data: spend, borderColor: '#f72585', backgroundColor: 'rgba(247,37,133,0.15)', fill: true }
                ]},
                options: { responsive: true, plugins: { legend: { position: 'bottom' } }, scales: { y: { beginAtZero: true } } }
            });
        }

        const distCtx = document.getElementById('distributionChart');
        if (distCtx) {
            const statuses = Object.keys(statusCounts);
            const values = Object.values(statusCounts);
            new Chart(distCtx, {
                type: 'doughnut',
                data: {
                    labels: statuses,
                    datasets: [{ data: values, backgroundColor: ['#22c55e', '#ef4444', '#6b7280', '#f59e0b'] }]
                },
                options: { responsive: true, plugins: { legend: { position: 'bottom' } } }
            });
        }
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('FrontUser.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcallcrm\resources\views/FrontUser/Reports/index.blade.php ENDPATH**/ ?>