<?php $__env->startSection('content'); ?>
<div class="container">
    <h1><?php echo e($ticket->subject); ?></h1>
    <p><strong>User:</strong> <?php echo e($ticket->user->name); ?></p>
    <p><strong>Status:</strong> <?php echo e($ticket->status); ?></p>

    <div class="card">
        <div class="card-body">
            <p><?php echo e($ticket->message); ?></p>
            <?php if($ticket->image_path): ?>
            <img src="<?php echo e(asset('storage/' . $ticket->image_path)); ?>" alt="Ticket Image" style="max-width: 100%;">
            <?php endif; ?>
        </div>
        <div class="card-footer text-muted">
            <?php echo e($ticket->created_at->diffForHumans()); ?>

        </div>
    </div>

    <hr>

    <h3>Replies</h3>

    <?php $__currentLoopData = $ticket->replies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="card mt-3">
        <div class="card-body">
            <p><?php echo e($reply->message); ?></p>
            <?php if($reply->image_path): ?>
            <img src="<?php echo e(asset('storage/' . $reply->image_path)); ?>" alt="Reply Image" style="max-width: 100%;">
            <?php endif; ?>
        </div>
        <div class="card-footer text-muted">
            <strong><?php echo e($reply->user->name); ?></strong> replied <?php echo e($reply->created_at->diffForHumans()); ?>

        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <hr>

    <?php if($ticket->status !== 'closed'): ?>
    <h3>Reply to Ticket</h3>
    <form action="<?php echo e(route('admin.tickets.reply', $ticket)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="form-group">
            <label for="message">Your Reply</label>
            <textarea name="message" id="message" class="form-control" rows="5" required></textarea>
        </div>
        <div class="form-group mt-3">
            <label for="image">Image (optional)</label>
            <input type="file" name="image" id="image" class="form-control">
        </div>
        <button type="submit" class="btn btn-primary mt-3">Send Reply</button>
    </form>

    <hr>

    <form action="<?php echo e(route('admin.tickets.close', $ticket)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <button type="submit" class="btn btn-danger">Close Ticket</button>
    </form>
    <?php else: ?>
    <div class="alert alert-info">This ticket is closed.</div>
    <?php endif; ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcallcrm\resources\views/admin/tickets/show.blade.php ENDPATH**/ ?>