

<?php $__env->startSection('title', 'Analytics'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
                <div class="card-header">
                    <h3 class="card-title">System Analytics</h3>
                    <div class="card-tools">
                        <select class="form-select">
                            <option>Last 7 Days</option>
                            <option>Last 30 Days</option>
                            <option>Last 90 Days</option>
                        </select>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Total Users</h5>
                                    <h2><?php echo e(number_format($totalUsers)); ?></h2>
                                    <span class="text-success">+<?php echo e($newUsersThisWeek); ?> this week</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Active Calls</h5>
                                    <h2><?php echo e(number_format($activeCalls)); ?></h2>
                                    <span class="text-success">+<?php echo e($callsToday); ?> today</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>API Requests</h5>
                                    <h2><?php echo e(number_format($totalApiRequests / 1000, 1)); ?>K</h2>
                                    <span class="text-success">+<?php echo e(number_format($apiRequestsToday / 1000, 1)); ?>K today</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stat-card">
                                <div class="card-body text-center">
                                    <h5>Success Rate</h5>
                                    <h2><?php echo e($successRate); ?>%</h2>
                                    <span class="text-success">Active users: <?php echo e($activeUsers); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>User Growth</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="userGrowthChart" height="300"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Call Volume</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="callVolumeChart" height="300"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Geographic Distribution</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="geographicChart" height="300"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Peak Hours</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="peakHoursChart" height="300"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Chart data from PHP
    const userGrowthData = <?php echo json_encode($userGrowthData, 15, 512) ?>;
    const callVolumeData = <?php echo json_encode($callVolumeData, 15, 512) ?>;
    const geographicData = <?php echo json_encode($geographicData, 15, 512) ?>;
    const peakHoursData = <?php echo json_encode($peakHoursData, 15, 512) ?>;

    // User Growth Chart
    const userGrowthCtx = document.getElementById('userGrowthChart');
    if (userGrowthCtx) {
        new Chart(userGrowthCtx, {
            type: 'line',
            data: {
                labels: userGrowthData.labels,
                datasets: [{
                    label: 'New Users',
                    data: userGrowthData.data,
                    borderColor: '#4361ee',
                    backgroundColor: 'rgba(67, 97, 238, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        }
                    }
                }
            }
        });
    }

    // Call Volume Chart
    const callVolumeCtx = document.getElementById('callVolumeChart');
    if (callVolumeCtx) {
        new Chart(callVolumeCtx, {
            type: 'bar',
            data: {
                labels: callVolumeData.labels,
                datasets: [{
                    label: 'Calls',
                    data: callVolumeData.data,
                    backgroundColor: 'rgba(76, 201, 240, 0.8)',
                    borderColor: '#4cc9f0',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        }
                    }
                }
            }
        });
    }

    // Geographic Distribution Chart
    const geographicCtx = document.getElementById('geographicChart');
    if (geographicCtx) {
        new Chart(geographicCtx, {
            type: 'doughnut',
            data: {
                labels: geographicData.labels,
                datasets: [{
                    data: geographicData.data,
                    backgroundColor: [
                        '#4361ee',
                        '#4cc9f0',
                        '#f72585',
                        '#4ade80',
                        '#f59e0b'
                    ],
                    borderWidth: 0
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            padding: 20,
                            usePointStyle: true
                        }
                    }
                }
            }
        });
    }

    // Peak Hours Chart
    const peakHoursCtx = document.getElementById('peakHoursChart');
    if (peakHoursCtx) {
        new Chart(peakHoursCtx, {
            type: 'bar',
            data: {
                labels: peakHoursData.labels,
                datasets: [{
                    label: 'Calls',
                    data: peakHoursData.data,
                    backgroundColor: 'rgba(247, 37, 133, 0.8)',
                    borderColor: '#f72585',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0,0,0,0.1)'
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        }
                    }
                }
            }
        });
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcallcrm\resources\views/admin/analytics/index.blade.php ENDPATH**/ ?>