

<?php $__env->startSection('title', 'Call Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="calls-dashboard">
    <!-- Page Header -->
    <div class="page-header mb-4">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2 class="page-title">Call Management</h2>
                <p class="page-subtitle">Manage your calls and view analytics</p>
            </div>
            <div class="page-actions">
                <a href="<?php echo e(route('user.calls.create')); ?>" class="btn btn-primary me-2">
                    <i class="fas fa-plus"></i> Schedule New Call
                </a>
                <a href="<?php echo e(route('user.calls.bulk.create')); ?>" class="btn btn-outline-primary">
                    <i class="fas fa-upload"></i> Bulk Schedule
                </a>
            </div>
        </div>
    </div>

    <!-- Call Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-phone"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-title">Total Calls</div>
                    <div class="stat-value"><?php echo e(number_format($totalCalls)); ?></div>
                    <div class="stat-change">
                        This month: <?php echo e(number_format($thisMonthCalls)); ?>

                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-title">Total Duration</div>
                    <div class="stat-value"><?php echo e(number_format($totalDuration / 60, 1)); ?>h</div>
                    <div class="stat-change">
                        Average: <?php echo e(number_format($totalDuration / max($totalCalls, 1), 1)); ?>min
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-rupee-sign"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-title">Total Cost</div>
                    <div class="stat-value">₹<?php echo e(number_format($totalCost, 2)); ?></div>
                    <div class="stat-change">
                        Average: ₹<?php echo e(number_format($totalCost / max($totalCalls, 1), 2)); ?>

                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-title">Success Rate</div>
                    <div class="stat-value"><?php echo e($totalCalls > 0 ? number_format(($totalCalls / max($totalCalls, 1)) * 100, 1) : 0); ?>%</div>
                    <div class="stat-change">
                        Completed calls
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="quick-action" onclick="window.location.href='<?php echo e(route('user.calls.create')); ?>'">
                                <div class="action-icon">
                                    <i class="fas fa-plus"></i>
                                </div>
                                <div class="action-content">
                                    <h6>Schedule Call</h6>
                                    <p>Book a new call</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="quick-action" onclick="showCallAnalytics()">
                                <div class="action-icon">
                                    <i class="fas fa-chart-bar"></i>
                                </div>
                                <div class="action-content">
                                    <h6>View Analytics</h6>
                                    <p>Call insights & reports</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="quick-action" onclick="showCallPackages()">
                                <div class="action-icon">
                                    <i class="fas fa-box"></i>
                                </div>
                                <div class="action-content">
                                    <h6>Call Packages</h6>
                                    <p>View available plans</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="quick-action" onclick="showCallHistory()">
                                <div class="action-icon">
                                    <i class="fas fa-history"></i>
                                </div>
                                <div class="action-content">
                                    <h6>Call History</h6>
                                    <p>View all past calls</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Calls -->
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title">Recent Calls</h5>
                    <div class="card-actions">
                        <button class="btn btn-outline-primary btn-sm" onclick="refreshCalls()">
                            <i class="fas fa-sync"></i> Refresh
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <?php if($calls->count() > 0): ?>
                        <div class="calls-list">
                            <?php $__currentLoopData = $calls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $call): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="call-item">
                                <div class="call-icon">
                                    <i class="fas fa-phone <?php echo e($call->status === 'completed' ? 'text-success' : ($call->status === 'in_progress' ? 'text-warning' : 'text-info')); ?>"></i>
                                </div>
                                <div class="call-details">
                                    <div class="call-number"><?php echo e($call->phone_number); ?></div>
                                    <div class="call-meta">
                                        <span class="call-package"><?php echo e(ucfirst($call->package)); ?> Plan</span>
                                        <span class="call-date"><?php echo e($call->date_time->format('M d, Y h:i A')); ?></span>
                                    </div>
                                </div>
                                <div class="call-status">
                                    <span class="status-badge status-<?php echo e($call->status); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $call->status))); ?>

                                    </span>
                                    <div class="call-cost">₹<?php echo e(number_format($call->cost, 2)); ?></div>
                                </div>
                                <div class="call-actions">
                                    <?php if($call->status === 'scheduled'): ?>
                                        <button class="btn btn-sm btn-success" onclick="startCall(<?php echo e($call->id); ?>)" title="Start Call">
                                            <i class="fas fa-play"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" onclick="editCall(<?php echo e($call->id); ?>)" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="cancelCall(<?php echo e($call->id); ?>)" title="Cancel">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    <?php elseif($call->status === 'in_progress'): ?>
                                        <button class="btn btn-sm btn-danger" onclick="endCall(<?php echo e($call->id); ?>)" title="End Call">
                                            <i class="fas fa-stop"></i>
                                        </button>
                                    <?php elseif($call->status === 'completed'): ?>
                                        <a href="<?php echo e(route('user.calls.show', $call->id)); ?>" class="btn btn-sm btn-primary" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php if($call->recording_url): ?>
                                        <button class="btn btn-sm btn-info" onclick="playRecording('<?php echo e($call->recording_url); ?>')" title="Play Recording">
                                            <i class="fas fa-play"></i>
                                        </button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center mt-4">
                            <?php echo e($calls->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="empty-state">
                            <i class="fas fa-phone"></i>
                            <h6>No calls found</h6>
                            <p>Your call history will appear here</p>
                            <a href="<?php echo e(route('user.calls.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Schedule Your First Call
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Call Insights</h5>
                </div>
                <div class="card-body">
                    <div class="insight-item">
                        <div class="insight-label">Most Used Package</div>
                        <div class="insight-value"><?php echo e(ucfirst($calls->groupBy('package')->sortByDesc(function($group) { return $group->count(); })->keys()->first() ?? 'Basic')); ?></div>
                    </div>
                    <div class="insight-item">
                        <div class="insight-label">Average Call Duration</div>
                        <div class="insight-value"><?php echo e(number_format($totalDuration / max($totalCalls, 1), 1)); ?> minutes</div>
                    </div>
                    <div class="insight-item">
                        <div class="insight-label">Total Cost This Month</div>
                        <div class="insight-value">₹<?php echo e(number_format($totalCost, 2)); ?></div>
                    </div>
                    <div class="insight-item">
                        <div class="insight-label">Call Success Rate</div>
                        <div class="insight-value">
                            <span class="health-indicator <?php echo e(($totalCalls / max($totalCalls, 1)) * 100 > 80 ? 'healthy' : (($totalCalls / max($totalCalls, 1)) * 100 > 60 ? 'warning' : 'low')); ?>">
                                <?php echo e($totalCalls > 0 ? number_format(($totalCalls / max($totalCalls, 1)) * 100, 1) : 0); ?>%
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Call Analytics Modal -->
<div class="modal fade" id="callAnalyticsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Call Analytics</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <canvas id="callDurationChart" height="200"></canvas>
                    </div>
                    <div class="col-md-6">
                        <canvas id="callCostChart" height="200"></canvas>
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-md-12">
                        <canvas id="callTrendChart" height="200"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Call Packages Modal -->
<div class="modal fade" id="callPackagesModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Available Call Packages</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="package-card">
                            <div class="package-header">
                                <h6>Basic Plan</h6>
                                <div class="package-price">₹0.50</div>
                            </div>
                            <div class="package-features">
                                <ul>
                                    <li>Standard quality</li>
                                    <li>Basic recording</li>
                                    <li>Email support</li>
                                    <li>60 minutes duration</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="package-card featured">
                            <div class="package-badge">Most Popular</div>
                            <div class="package-header">
                                <h6>Premium Plan</h6>
                                <div class="package-price">₹1.00</div>
                            </div>
                            <div class="package-features">
                                <ul>
                                    <li>HD quality</li>
                                    <li>Advanced recording</li>
                                    <li>Priority support</li>
                                    <li>Analytics</li>
                                    <li>120 minutes duration</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="package-card">
                            <div class="package-header">
                                <h6>Enterprise Plan</h6>
                                <div class="package-price">₹2.00</div>
                            </div>
                            <div class="package-features">
                                <ul>
                                    <li>4K quality</li>
                                    <li>Full recording</li>
                                    <li>24/7 support</li>
                                    <li>Advanced analytics</li>
                                    <li>API access</li>
                                    <li>300 minutes duration</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Show call analytics
function showCallAnalytics() {
    new bootstrap.Modal(document.getElementById('callAnalyticsModal')).show();
    
    // Load analytics data
    fetch('/user/calls/analytics')
        .then(response => response.json())
        .then(data => {
            // Create charts
            createCallDurationChart(data);
            createCallCostChart(data);
            createCallTrendChart(data);
        });
}

// Show call packages
function showCallPackages() {
    new bootstrap.Modal(document.getElementById('callPackagesModal')).show();
}

// Show call history
function showCallHistory() {
    // Scroll to calls list
    document.querySelector('.calls-list').scrollIntoView({ behavior: 'smooth' });
}

// Start call
function startCall(callId) {
    if (confirm('Are you sure you want to start this call?')) {
        fetch(`/user/calls/${callId}/start`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showNotification('success', data.message);
                location.reload();
            } else {
                showNotification('error', data.message);
            }
        });
    }
}

// End call
function endCall(callId) {
    if (confirm('Are you sure you want to end this call?')) {
        fetch(`/user/calls/${callId}/end`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showNotification('success', data.message);
                location.reload();
            } else {
                showNotification('error', data.message);
            }
        });
    }
}

// Edit call
function editCall(callId) {
    window.location.href = `/user/calls/${callId}/edit`;
}

// Cancel call
function cancelCall(callId) {
    if (confirm('Are you sure you want to cancel this call? You will receive a full refund.')) {
        fetch(`/user/calls/${callId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showNotification('success', data.message);
                location.reload();
            } else {
                showNotification('error', data.message);
            }
        });
    }
}

// Play recording
function playRecording(url) {
    window.open(url, '_blank');
}

// Refresh calls
function refreshCalls() {
    location.reload();
}

// Create call duration chart
function createCallDurationChart(data) {
    const ctx = document.getElementById('callDurationChart');
    new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['Completed', 'In Progress', 'Scheduled', 'Failed'],
            datasets: [{
                data: [data.completed_calls, data.in_progress_calls || 0, data.scheduled_calls || 0, data.failed_calls || 0],
                backgroundColor: ['#10b981', '#f59e0b', '#3b82f6', '#ef4444']
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                title: {
                    display: true,
                    text: 'Call Status Distribution'
                }
            }
        }
    });
}

// Create call cost chart
function createCallCostChart(data) {
    const ctx = document.getElementById('callCostChart');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['This Month', 'Last Month', 'Total'],
            datasets: [{
                label: 'Cost (₹)',
                data: [data.cost_this_month, data.cost_last_month || 0, data.total_cost],
                backgroundColor: '#4f46e5'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                title: {
                    display: true,
                    text: 'Call Costs'
                }
            }
        }
    });
}

// Create call trend chart
function createCallTrendChart(data) {
    const ctx = document.getElementById('callTrendChart');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: ['Week 1', 'Week 2', 'Week 3', 'Week 4'],
            datasets: [{
                label: 'Calls',
                data: [data.week1_calls || 0, data.week2_calls || 0, data.week3_calls || 0, data.week4_calls || 0],
                borderColor: '#4f46e5',
                backgroundColor: 'rgba(79, 70, 229, 0.1)',
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                title: {
                    display: true,
                    text: 'Call Trend (Last 4 Weeks)'
                }
            }
        }
    });
}

// Show notification
function showNotification(type, message) {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : 'error' ? 'danger' : 'info'} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.remove();
    }, 5000);
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    console.log('Call management loaded successfully!');
    
    // Animate stat cards
    const statCards = document.querySelectorAll('.stat-card');
    statCards.forEach((card, index) => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';
        setTimeout(() => {
            card.style.transition = 'all 0.6s ease';
            card.style.opacity = '1';
            card.style.transform = 'translateY(0)';
        }, index * 100);
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('FrontUser.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcallcrm\resources\views/FrontUser/calls/index.blade.php ENDPATH**/ ?>