

<?php $__env->startSection('title', 'Bulk Call Schedule'); ?>

<?php $__env->startSection('content'); ?>
<div class="bulk-call-page">
    <!-- Page Header -->
    <div class="page-header mb-4">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2 class="page-title">Bulk Call Schedule</h2>
                <p class="page-subtitle">Schedule multiple calls by importing phone numbers from Excel/CSV</p>
            </div>
            <div class="page-actions">
                <a href="<?php echo e(route('user.calls.index')); ?>" class="btn btn-outline-primary">
                    <i class="fas fa-arrow-left"></i> Back to Calls
                </a>
            </div>
        </div>
    </div>

    <?php if(!$hasBalance): ?>
    <div class="alert alert-warning">
        <i class="fas fa-exclamation-triangle"></i>
        <strong>Insufficient Balance:</strong> You need sufficient balance to schedule bulk calls. 
        <a href="<?php echo e(route('user.wallet.index')); ?>" class="alert-link">Add funds to your wallet</a>.
    </div>
    <?php endif; ?>

    <?php if(isset($licenseStatus) && !$licenseStatus['isActive']): ?>
    <div class="alert alert-info">
        <i class="fas fa-info-circle"></i>
        <strong>License Status:</strong> 
        <?php if($licenseStatus['startsAt'] && $licenseStatus['startsAt']->isFuture()): ?>
            Your license will be activated on <?php echo e($licenseStatus['startsAt']->format('M d, Y')); ?>. 
            You can schedule calls after that date.
        <?php elseif($licenseStatus['expiresAt'] && $licenseStatus['expiresAt']->isPast()): ?>
            Your license has expired on <?php echo e($licenseStatus['expiresAt']->format('M d, Y')); ?>. 
            Please contact support to renew your license.
        <?php else: ?>
            Your license is currently inactive. Please contact support for assistance.
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Bulk Call Details</h5>
                </div>
                <div class="card-body">
                    <form id="bulkCallForm" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        
                        <!-- File Upload Section -->
                        <div class="form-group mb-4">
                            <label class="form-label">Upload Phone Numbers File</label>
                            <div class="file-upload-area" id="fileUploadArea">
                                <div class="file-upload-content">
                                    <i class="fas fa-cloud-upload-alt fa-3x text-muted mb-3"></i>
                                    <h6>Drag & Drop your Excel/CSV file here</h6>
                                    <p class="text-muted">or click to browse</p>
                                    <input type="file" class="form-control" name="excel_file" id="excel_file" 
                                           accept=".xlsx,.xls,.csv" required>
                                </div>
                                <div class="file-upload-preview" id="filePreview" style="display: none;">
                                    <div class="file-info">
                                        <i class="fas fa-file-excel text-success"></i>
                                        <div class="file-details">
                                            <div class="file-name" id="fileName"></div>
                                            <div class="file-size" id="fileSize"></div>
                                        </div>
                                        <button type="button" class="btn btn-sm btn-outline-danger" id="removeFile">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <small class="form-text text-muted">
                                Supported formats: Excel (.xlsx, .xls) and CSV (.csv). Maximum file size: 10MB.
                            </small>
                        </div>

                        <!-- File Format Instructions -->
                        <div class="alert alert-info">
                            <h6><i class="fas fa-info-circle"></i> File Format Instructions:</h6>
                            <ul class="mb-0">
                                <li>First column should contain phone numbers</li>
                                <li>Include country code (e.g., +91 for India)</li>
                                <li>One phone number per row</li>
                                <li>Example: +91-9876543210, +1-555-123-4567</li>
                            </ul>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Call Package</label>
                                    <select class="form-select" name="package" id="package" required>
                                        <option value="">Select Package</option>
                                        <option value="basic">Basic Plan - ₹0.50 per call (60 min)</option>
                                        <option value="premium">Premium Plan - ₹1.00 per call (120 min)</option>
                                        <option value="enterprise">Enterprise Plan - ₹2.00 per call (300 min)</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Scheduled Time</label>
                                    <input type="datetime-local" class="form-control" name="scheduled_time" 
                                           id="scheduled_time" min="<?php echo e(date('Y-m-d\TH:i')); ?>">
                                    <small class="form-text">Leave empty for immediate scheduling (5 minutes from now)</small>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="terms" required>
                                <label class="form-check-label" for="terms">
                                    I agree to the <a href="#" class="text-primary">Terms of Service</a> and <a href="#" class="text-primary">Privacy Policy</a>
                                </label>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary btn-lg" <?php echo e(!$hasBalance ? 'disabled' : ''); ?>>
                            <i class="fas fa-upload"></i> Process Bulk Calls
                        </button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Bulk Call Summary</h5>
                </div>
                <div class="card-body">
                    <div class="summary-item">
                        <div class="summary-label">Selected Package:</div>
                        <div class="summary-value" id="selectedPackage">None</div>
                    </div>
                    <div class="summary-item">
                        <div class="summary-label">Phone Numbers:</div>
                        <div class="summary-value" id="phoneCount">0</div>
                    </div>
                    <div class="summary-item">
                        <div class="summary-label">Cost per Call:</div>
                        <div class="summary-value" id="costPerCall">₹0.00</div>
                    </div>
                    <div class="summary-item">
                        <div class="summary-label">Total Cost:</div>
                        <div class="summary-value" id="totalCost">₹0.00</div>
                    </div>
                    <div class="summary-item">
                        <div class="summary-label">Your Balance:</div>
                        <div class="summary-value">₹<?php echo e(number_format(Auth::user()->wallet_balance ?? 0, 2)); ?></div>
                    </div>
                    <hr>
                    <div class="summary-item total">
                        <div class="summary-label">Estimated Total:</div>
                        <div class="summary-value" id="estimatedTotal">₹0.00</div>
                    </div>
                </div>
            </div>

            <?php if(isset($licenseStatus)): ?>
            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="card-title">License Information</h5>
                </div>
                <div class="card-body">
                    <div class="license-info">
                        <div class="license-item">
                            <div class="license-label">Status:</div>
                            <div class="license-value">
                                <span class="badge bg-<?php echo e($licenseStatus['isActive'] ? 'success' : 'warning'); ?>">
                                    <?php echo e($licenseStatus['isActive'] ? 'Active' : 'Inactive'); ?>

                                </span>
                            </div>
                        </div>
                        <?php if($licenseStatus['startsAt']): ?>
                        <div class="license-item">
                            <div class="license-label">Start Date:</div>
                            <div class="license-value"><?php echo e($licenseStatus['startsAt']->format('M d, Y')); ?></div>
                        </div>
                        <?php endif; ?>
                        <?php if($licenseStatus['expiresAt']): ?>
                        <div class="license-item">
                            <div class="license-label">Expiry Date:</div>
                            <div class="license-value"><?php echo e($licenseStatus['expiresAt']->format('M d, Y')); ?></div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="card-title">Bulk Call Tips</h5>
                </div>
                <div class="card-body">
                    <div class="tip-item">
                        <i class="fas fa-clock text-info"></i>
                        <div>
                            <strong>Staggered Calls:</strong> Calls will be scheduled 5 minutes apart to avoid conflicts.
                        </div>
                    </div>
                    <div class="tip-item">
                        <i class="fas fa-file-excel text-success"></i>
                        <div>
                            <strong>File Format:</strong> Use Excel or CSV with phone numbers in the first column.
                        </div>
                    </div>
                    <div class="tip-item">
                        <i class="fas fa-shield-alt text-warning"></i>
                        <div>
                            <strong>Validation:</strong> Invalid phone numbers will be automatically filtered out.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
.file-upload-area {
    border: 2px dashed #dee2e6;
    border-radius: 10px;
    padding: 2rem;
    text-align: center;
    transition: all 0.3s ease;
    cursor: pointer;
    position: relative;
}

.file-upload-area:hover {
    border-color: #007bff;
    background-color: #f8f9fa;
}

.file-upload-area.dragover {
    border-color: #007bff;
    background-color: #e3f2fd;
}

.file-upload-content {
    pointer-events: none;
}

.file-upload-area input[type="file"] {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}

.file-upload-preview {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 8px;
    border: 1px solid #dee2e6;
}

.file-info {
    display: flex;
    align-items: center;
    flex: 1;
}

.file-info i {
    font-size: 2rem;
    margin-right: 1rem;
}

.file-details {
    flex: 1;
}

.file-name {
    font-weight: 600;
    color: #2c3e50;
}

.file-size {
    font-size: 0.9rem;
    color: #6c757d;
}

.summary-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f1f3f4;
}

.summary-item:last-child {
    border-bottom: none;
}

.summary-item.total {
    font-weight: 600;
    font-size: 1.1rem;
    color: #2c3e50;
}

.summary-label {
    color: #6c757d;
    font-size: 0.9rem;
}

.summary-value {
    font-weight: 600;
    color: #2c3e50;
}

.license-info {
    font-size: 0.9rem;
}

.license-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.5rem 0;
    border-bottom: 1px solid #f1f3f4;
}

.license-item:last-child {
    border-bottom: none;
}

.license-label {
    font-weight: 500;
    color: #6c757d;
}

.license-value {
    font-weight: 600;
    color: #2c3e50;
}

.tip-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 1rem;
}

.tip-item:last-child {
    margin-bottom: 0;
}

.tip-item i {
    margin-right: 0.75rem;
    margin-top: 0.25rem;
    font-size: 1.1rem;
}

.tip-item div {
    flex: 1;
}

.tip-item strong {
    display: block;
    margin-bottom: 0.25rem;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
const packages = {
    'basic': { price: 0.50, duration: 60 },
    'premium': { price: 1.00, duration: 120 },
    'enterprise': { price: 2.00, duration: 300 }
};

let phoneCount = 0;

// File upload handling
const fileUploadArea = document.getElementById('fileUploadArea');
const fileInput = document.getElementById('excel_file');
const filePreview = document.getElementById('filePreview');
const fileName = document.getElementById('fileName');
const fileSize = document.getElementById('fileSize');

fileUploadArea.addEventListener('click', () => fileInput.click());
fileUploadArea.addEventListener('dragover', (e) => {
    e.preventDefault();
    fileUploadArea.classList.add('dragover');
});
fileUploadArea.addEventListener('dragleave', () => {
    fileUploadArea.classList.remove('dragover');
});
fileUploadArea.addEventListener('drop', (e) => {
    e.preventDefault();
    fileUploadArea.classList.remove('dragover');
    const files = e.dataTransfer.files;
    if (files.length > 0) {
        fileInput.files = files;
        handleFileSelect(files[0]);
    }
});

fileInput.addEventListener('change', (e) => {
    if (e.target.files.length > 0) {
        handleFileSelect(e.target.files[0]);
    }
});

document.getElementById('removeFile').addEventListener('click', () => {
    fileInput.value = '';
    filePreview.style.display = 'none';
    fileUploadArea.querySelector('.file-upload-content').style.display = 'block';
    phoneCount = 0;
    updateSummary();
});

function handleFileSelect(file) {
    fileName.textContent = file.name;
    fileSize.textContent = formatFileSize(file.size);
    filePreview.style.display = 'flex';
    fileUploadArea.querySelector('.file-upload-content').style.display = 'none';
    
    // Estimate phone count (simplified)
    phoneCount = Math.max(1, Math.floor(file.size / 20)); // Rough estimate
    updateSummary();
}

function formatFileSize(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}

// Package selection handling
document.getElementById('package').addEventListener('change', function() {
    updateSummary();
});

function updateSummary() {
    const selectedPackage = document.getElementById('package').value;
    const packageInfo = packages[selectedPackage];
    
    if (packageInfo) {
        document.getElementById('selectedPackage').textContent = selectedPackage.charAt(0).toUpperCase() + selectedPackage.slice(1) + ' Plan';
        document.getElementById('costPerCall').textContent = '₹' + packageInfo.price.toFixed(2);
        document.getElementById('phoneCount').textContent = phoneCount;
        document.getElementById('totalCost').textContent = '₹' + (packageInfo.price * phoneCount).toFixed(2);
        document.getElementById('estimatedTotal').textContent = '₹' + (packageInfo.price * phoneCount).toFixed(2);
    } else {
        document.getElementById('selectedPackage').textContent = 'None';
        document.getElementById('costPerCall').textContent = '₹0.00';
        document.getElementById('totalCost').textContent = '₹0.00';
        document.getElementById('estimatedTotal').textContent = '₹0.00';
    }
}

// Form submission
document.getElementById('bulkCallForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
    submitBtn.disabled = true;
    
    fetch('<?php echo e(route("user.calls.bulk.store")); ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification('success', data.message);
            setTimeout(() => {
                window.location.href = '<?php echo e(route("user.calls.index")); ?>';
            }, 2000);
        } else {
            showNotification('error', data.message);
        }
    })
    .catch(error => {
        showNotification('error', 'An error occurred. Please try again.');
    })
    .finally(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
});

// Show notification
function showNotification(type, message) {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : 'error' ? 'danger' : 'info'} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.remove();
    }, 5000);
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    console.log('Bulk call creation page loaded successfully!');
    updateSummary();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('FrontUser.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\dizzcall-ai\resources\views/FrontUser/calls/bulk-create.blade.php ENDPATH**/ ?>