<?php

require_once 'vendor/autoload.php';

use App\Services\AI\Phi3Service;

echo "🤖 Testing AI Connection...\n";
echo "==========================\n\n";

try {
    $phi3 = new Phi3Service();
    $result = $phi3->testConnection();
    
    echo "Test Result:\n";
    echo json_encode($result, JSON_PRETTY_PRINT) . "\n\n";
    
    if ($result['success']) {
        echo "✅ AI Connection Successful!\n";
        echo "You can now use the AI voice agent system.\n";
    } else {
        echo "❌ AI Connection Failed!\n";
        echo "Error: " . ($result['error'] ?? 'Unknown error') . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n";
