<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Marketplace
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Marketplace;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Marketplace\V1\AvailableAddOnList;
use Twilio\Rest\Marketplace\V1\InstalledAddOnList;
use Twilio\Rest\Marketplace\V1\ModuleDataList;
use Twilio\Rest\Marketplace\V1\ModuleDataManagementList;
use Twilio\Rest\Marketplace\V1\ReferralConversionList;
use Twilio\Version;

/**
 * @property AvailableAddOnList $availableAddOns
 * @property InstalledAddOnList $installedAddOns
 * @property ModuleDataList $moduleData
 * @property ModuleDataManagementList $moduleDataManagement
 * @property ReferralConversionList $referralConversion
 * @method \Twilio\Rest\Marketplace\V1\AvailableAddOnContext availableAddOns(string $sid)
 * @method \Twilio\Rest\Marketplace\V1\InstalledAddOnContext installedAddOns(string $sid)
 * @method \Twilio\Rest\Marketplace\V1\ModuleDataManagementContext moduleDataManagement(string $sid)
 */
class V1 extends Version
{
    protected $_availableAddOns;
    protected $_installedAddOns;
    protected $_moduleData;
    protected $_moduleDataManagement;
    protected $_referralConversion;

    /**
     * Construct the V1 version of Marketplace
     *
     * @param Domain $domain Domain that contains the version
     */
    public function __construct(Domain $domain)
    {
        parent::__construct($domain);
        $this->version = 'v1';
    }

    protected function getAvailableAddOns(): AvailableAddOnList
    {
        if (!$this->_availableAddOns) {
            $this->_availableAddOns = new AvailableAddOnList($this);
        }
        return $this->_availableAddOns;
    }

    protected function getInstalledAddOns(): InstalledAddOnList
    {
        if (!$this->_installedAddOns) {
            $this->_installedAddOns = new InstalledAddOnList($this);
        }
        return $this->_installedAddOns;
    }

    protected function getModuleData(): ModuleDataList
    {
        if (!$this->_moduleData) {
            $this->_moduleData = new ModuleDataList($this);
        }
        return $this->_moduleData;
    }

    protected function getModuleDataManagement(): ModuleDataManagementList
    {
        if (!$this->_moduleDataManagement) {
            $this->_moduleDataManagement = new ModuleDataManagementList($this);
        }
        return $this->_moduleDataManagement;
    }

    protected function getReferralConversion(): ReferralConversionList
    {
        if (!$this->_referralConversion) {
            $this->_referralConversion = new ReferralConversionList($this);
        }
        return $this->_referralConversion;
    }

    /**
     * Magic getter to lazy load root resources
     *
     * @param string $name Resource to return
     * @return \Twilio\ListResource The requested resource
     * @throws TwilioException For unknown resource
     */
    public function __get(string $name)
    {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown resource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext
    {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Marketplace.V1]';
    }
}
