<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Default route
$route['default_controller'] = 'auth/login';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

// Public Portfolio Routes (must be before project routes)
// IMPORTANT: Order matters - more specific routes first
// Portfolio routes
$route['portfolio/model/(:any)/(:any)'] = 'portfolio/model/$1/$2';
$route['portfolio/view/(:any)/(:any)'] = 'portfolio/view/$1/$2';
$route['portfolio/view/(:any)'] = 'portfolio/view/$1';
$route['portfolio/project/(:any)'] = 'portfolio/project/$1';
$route['portfolio/(:any)/(:any)'] = 'portfolio/model/$1/$2';
$route['portfolio/(:any)'] = 'portfolio/project/$1';
// Project Management Routes
$route['project'] = 'project/index';
$route['project/create'] = 'project/create';
$route['project/save_project'] = 'project/save_project';
$route['project/upload/(:any)'] = 'project/upload/$1';
$route['project/process_upload/(:any)'] = 'project/process_upload/$1';
$route['project/view/(:any)'] = 'project/view/$1';
$route['project/update_model_info/(:num)'] = 'project/update_model_info/$1';
$route['project/upload_additional_photo/(:any)'] = 'project/upload_additional_photo/$1';
$route['project/get_project_status/(:any)'] = 'project/get_project_status/$1';
$route['project/delete_project/(:any)'] = 'project/delete_project/$1';

// Authentication Routes
$route['auth/login'] = 'auth/login';
$route['auth/logout'] = 'auth/logout';
$route['auth/process_login'] = 'auth/process_login';

// PDF Extractor Routes
$route['pdf-extractor'] = 'pdf_extractor/index';
$route['pdf-extractor/create-project'] = 'pdf_extractor/create_project';
$route['pdf-extractor/set-active-project/(:num)'] = 'pdf_extractor/set_active_project/$1';
$route['pdf-extractor/upload-bulk-pdfs'] = 'pdf_extractor/upload_bulk_pdfs';
$route['pdf-extractor/process-batch/(:any)'] = 'pdf_extractor/process_batch/$1';
$route['pdf-extractor/check-batch-status/(:any)'] = 'pdf_extractor/check_batch_status/$1';
$route['pdf-extractor/results'] = 'pdf_extractor/results';
$route['pdf-extractor/results/(:num)'] = 'pdf_extractor/results/$1';
$route['pdf-extractor/export-project/(:num)'] = 'pdf_extractor/export_project/$1';

// Admin Routes
$route['admin'] = 'admin/dashboard';
$route['admin/dashboard'] = 'admin/dashboard';
$route['admin/portfolio'] = 'admin/portfolio';
$route['admin/enquiries'] = 'admin/enquiries';
$route['admin/categories'] = 'admin/categories';
$route['admin/users'] = 'admin/users';
$route['admin/create_user'] = 'admin/create_user';
$route['admin/update_user/(:num)'] = 'admin/update_user/$1';
$route['admin/delete_user/(:num)'] = 'admin/delete_user/$1';
$route['admin/get_user_details/(:num)'] = 'admin/get_user_details/$1';
$route['admin/get_user_edit_data/(:num)'] = 'admin/get_user_edit_data/$1';

// PDF Simple Routes
$route['pdf-simple'] = 'pdf_simple/index';
$route['pdf-simple/upload-single'] = 'pdf_simple/upload_single';
$route['pdf-simple/results'] = 'pdf_simple/results';
$route['admin/get_dashboard_data'] = 'admin/get_dashboard_data';
$route['admin/get_recent_projects'] = 'admin/get_recent_projects';
$route['admin/get_recent_activity'] = 'admin/get_recent_activity';
$route['admin/cleanup_temp_files'] = 'admin/cleanup_temp_files';
?>