<?php
defined('BASEPATH') OR exit('No direct script access allowed');

#[AllowDynamicProperties]
class MY_Controller extends CI_Controller {

    public function __construct() {
        parent::__construct();
        
        // Fix for PHP 8.2 dynamic properties
        $this->load = new CI_Loader();
        $this->benchmark =& load_class('Benchmark', 'core');
        $this->hooks =& load_class('Hooks', 'core');
        $this->config =& load_class('Config', 'core');
        $this->log =& load_class('Log', 'core');
        $this->utf8 =& load_class('Utf8', 'core');
        $this->uri =& load_class('URI', 'core');
        $this->router =& load_class('Router', 'core');
        $this->output =& load_class('Output', 'core');
        $this->security =& load_class('Security', 'core');
        $this->input =& load_class('Input', 'core');
        $this->lang =& load_class('Lang', 'core');
        
        // Initialize the loader
        $this->load->initialize();
        
        // Check authentication
        $this->check_auth();
    }
    
    protected function check_auth() {
        $allowed_controllers = ['auth'];
        $current_controller = $this->router->class;
        
        if (!in_array($current_controller, $allowed_controllers) && !$this->session->userdata('logged_in')) {
            redirect('auth/login');
        }
    }
}