<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Batch_model extends CI_Model {

    public function __construct() {
  log_message('info', 'Batch_model initialized');
    }

    public function create_batch_record($upload_data) {
        $data = array(
            'original_name' => $upload_data['orig_name'],
            'filename' => $upload_data['file_name'],
            'file_size' => $upload_data['file_size'],
            'uploaded_at' => date('Y-m-d H:i:s'),
            'status' => 'pending',
            'batch_id' => uniqid()
        );

        $this->db->insert('pdf_records', $data);
        return $this->db->insert_id();
    }

    public function get_record($record_id) {
        return $this->db->get_where('pdf_records', array('id' => $record_id))->row();
    }

    public function update_record($record_id, $data) {
        $this->db->where('id', $record_id);
        return $this->db->update('pdf_records', $data);
    }

    public function get_batch_stats() {
        $stats = array(
            'total_files' => 0,
            'total_images' => 0,
            'disk_space' => $this->get_disk_space()
        );

        $this->db->select('COUNT(*) as total_files');
        $stats['total_files'] = $this->db->count_all_results('pdf_records');

        // Count images (this would need to be calculated from result_data)
        $stats['total_images'] = 0;

        return $stats;
    }

    private function get_disk_space() {
        $free_space = disk_free_space(FCPATH);
        return round($free_space / 1024 / 1024 / 1024, 1);
    }
}