<main class="main-content" id="mainContent">
    <header class="main-header">
        <h1>PROJECT: <?php echo strtoupper(str_replace('_', ' ', $project_name)); ?></h1>
        <p class="welcome-text">View all PDFs and extracted images for this project</p>
    </header>

    <div class="content-area">
        <div style="margin-bottom: 20px;">
            <a href="<?php echo site_url('admin/portfolio'); ?>" class="btn btn-secondary" 
               style="padding: 8px 15px; background: #6c757d; color: white; text-decoration: none; border-radius: 4px;">
                ← Back to Portfolio
            </a>
        </div>

        <?php if (!empty($project_data['pdfs'])): ?>
            <div class="project-content">
                <?php foreach ($project_data['pdfs'] as $pdf): ?>
                    <div class="pdf-section" style="margin-bottom: 30px; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                        <h3>📄 <?php echo $pdf['name']; ?></h3>
                        
                        <?php if (!empty($project_data['images'][pathinfo($pdf['name'], PATHINFO_FILENAME)])): ?>
                            <h4>Extracted Images:</h4>
                            <div class="images-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 15px; margin-top: 15px;">
                                <?php foreach ($project_data['images'][pathinfo($pdf['name'], PATHINFO_FILENAME)] as $image): ?>
                                    <div class="image-item" style="text-align: center;">
                                        <img src="<?php echo $image['url']; ?>" 
                                             alt="<?php echo $image['filename']; ?>"
                                             style="max-width: 100%; height: 150px; object-fit: cover; border-radius: 4px; border: 1px solid #ddd;">
                                        <div style="font-size: 12px; color: #666; margin-top: 5px;">
                                            <?php echo $image['filename']; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <p style="color: #666; font-style: italic;">No images extracted from this PDF.</p>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="alert alert-info" style="padding: 20px; background: #d1ecf1; color: #0c5460; border-radius: 4px;">
                No PDFs found in this project.
            </div>
        <?php endif; ?>
    </div>
</main>