<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Inter', sans-serif; background: #0a0a0a; color: #fff; }
        .container { max-width: 1200px; margin: 0 auto; padding: 40px 20px; }
        .header { text-align: center; margin-bottom: 50px; }
        .logo { height: 60px; filter: brightness(0) invert(1); margin-bottom: 20px; }
        h1 { font-family: 'Bebas Neue', sans-serif; font-size: 48px; letter-spacing: 2px; }
        .project-name { color: #999; margin-top: 10px; }
        .models-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 25px; }
        .model-card { background: #1a1a1a; border-radius: 10px; overflow: hidden; transition: transform 0.3s ease; }
        .model-card:hover { transform: translateY(-5px); }
        .model-image { width: 100%; height: 350px; object-fit: cover; }
        .model-info { padding: 20px; }
        .model-name { font-size: 20px; font-weight: 600; margin-bottom: 10px; }
        .model-stats { display: flex; justify-content: space-between; color: #999; font-size: 12px; }
        .view-btn { display: block; margin-top: 15px; padding: 10px; background: #333; color: #fff; text-align: center; border-radius: 5px; }
        .view-btn:hover { background: #444; }
        .footer { text-align: center; margin-top: 60px; color: #666; font-size: 14px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="<?php echo base_url('assets/images/logogo.png'); ?>" alt="GO Productions" class="logo">
            <h1>MODEL PORTFOLIOS</h1>
            <div class="project-name"><?php echo htmlspecialchars($project->name); ?></div>
        </div>
        
        <div class="models-grid">
            <?php foreach ($models as $model): 
                $model_name = !empty($model['model_name']) ? $model['model_name'] : 
                             pathinfo($model['original_name'], PATHINFO_FILENAME);
                $first_image = null;
                
                // Get first image for thumbnail
                $ci =& get_instance();
                $ci->db->where('pdf_id', $model['id']);
                $ci->db->order_by('id');
                $ci->db->limit(1);
                $query = $ci->db->get('extracted_images');
                $first_image = $query->row();
            ?>
            <div class="model-card">
                <?php if ($first_image): ?>
                <img src="<?php echo base_url($first_image->image_path); ?>" 
                     alt="<?php echo htmlspecialchars($model_name); ?>" 
                     class="model-image">
                <?php endif; ?>
                <div class="model-info">
                    <div class="model-name"><?php echo htmlspecialchars($model_name); ?></div>
                    <div class="model-stats">
                        <span>Images: <?php echo $model['image_count'] ?? 0; ?></span>
                        <?php if (!empty($model['model_height'])): ?>
                        <span>Height: <?php echo htmlspecialchars($model['model_height']); ?></span>
                        <?php endif; ?>
                    </div>
                    <a href="<?php echo site_url('portfolio/model/' . $project->id . '/' . urlencode($model_name)); ?>" 
                       class="view-btn">View Portfolio</a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="footer">
            © <?php echo date('Y'); ?> GO Productions. All rights reserved.
        </div>
    </div>
</body>
</html>