<main class="main-content" id="mainContent">
    <header class="main-header">
        <h1>PROCESSING RESULTS</h1>
        <p class="welcome-text">Extracted model data from PDF portfolios</p>
    </header>

    <div class="content-area">
        <?php if (!empty($portfolio_data)): ?>
            <div class="project-header">
                <h2>Project: <?php echo $portfolio_data['project_name']; ?></h2>
                <p>Processed: <?php echo $portfolio_data['processed_at']; ?></p>
                <p>Total Size: <?php echo $this->format_bytes($portfolio_data['total_original_size']); ?></p>
            </div>

            <div class="results-grid">
                <?php foreach ($portfolio_data['models'] as $model): ?>
                    <div class="model-card">
                        <h3><?php echo $model['name'] ?? 'Unknown Model'; ?></h3>
                        <div class="model-details">
                            <?php if (isset($model['height'])): ?>
                                <div><strong>Height:</strong> <?php echo $model['height']; ?></div>
                            <?php endif; ?>
                            <?php if (isset($model['weight'])): ?>
                                <div><strong>Weight:</strong> <?php echo $model['weight']; ?></div>
                            <?php endif; ?>
                            <?php if (isset($model['measurements'])): ?>
                                <div><strong>Measurements:</strong> <?php echo $model['measurements']; ?></div>
                            <?php endif; ?>
                            <?php if (isset($model['age'])): ?>
                                <div><strong>Age:</strong> <?php echo $model['age']; ?></div>
                            <?php endif; ?>
                            <?php if (isset($model['location'])): ?>
                                <div><strong>Location:</strong> <?php echo $model['location']; ?></div>
                            <?php endif; ?>
                            <?php if (isset($model['instagram'])): ?>
                                <div><strong>Instagram:</strong> <?php echo $model['instagram']; ?></div>
                            <?php endif; ?>
                            <?php if (isset($model['email'])): ?>
                                <div><strong>Email:</strong> <?php echo $model['email']; ?></div>
                            <?php endif; ?>
                        </div>
                        
                        <?php if (!empty($model['extracted_images'])): ?>
                            <div class="model-images">
                                <h4>Extracted Images (<?php echo count($model['extracted_images']); ?>)</h4>
                                <div class="image-grid">
                                    <?php foreach ($model['extracted_images'] as $image): ?>
                                        <div class="image-item">
                                            <img src="<?php echo base_url(str_replace(FCPATH, '', $image['path'])); ?>" 
                                                 alt="<?php echo $image['filename']; ?>"
                                                 style="max-width: 100px; max-height: 100px;">
                                            <div class="image-info">
                                                <small><?php echo $image['filename']; ?></small>
                                                <small><?php echo $this->format_bytes($image['size']); ?></small>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="no-data">
                <h3>No processing data found</h3>
                <p>Please upload and process some PDF files first.</p>
                <a href="<?php echo base_url('portfolio'); ?>" class="btn btn-primary">
                    <i class="fas fa-upload"></i> Upload PDFs
                </a>
            </div>
        <?php endif; ?>
    </div>
</main>

<style>
.project-header {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 8px;
    margin-bottom: 30px;
    border-left: 4px solid #007bff;
}

.results-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(400px, 1fr));
    gap: 20px;
}

.model-card {
    background: white;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.model-card h3 {
    color: #333;
    margin-bottom: 15px;
    border-bottom: 2px solid #007bff;
    padding-bottom: 10px;
}

.model-details div {
    margin-bottom: 8px;
    padding: 5px 0;
    border-bottom: 1px solid #f0f0f0;
}

.model-details div:last-child {
    border-bottom: none;
}

.model-images {
    margin-top: 20px;
    padding-top: 20px;
    border-top: 1px solid #e0e0e0;
}

.image-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));
    gap: 10px;
    margin-top: 10px;
}

.image-item {
    text-align: center;
}

.image-item img {
    border-radius: 4px;
    border: 1px solid #ddd;
}

.image-info {
    margin-top: 5px;
}

.image-info small {
    display: block;
    color: #666;
}

.no-data {
    text-align: center;
    padding: 60px 20px;
    color: #666;
}

.btn {
    display: inline-block;
    background: #007bff;
    color: white;
    padding: 12px 24px;
    text-decoration: none;
    border-radius: 6px;
    font-weight: 600;
    margin-top: 15px;
}

.btn:hover {
    background: #0056b3;
    color: white;
    text-decoration: none;
}
</style>

<?php
// Helper function to format bytes
if (!function_exists('format_bytes')) {
    function format_bytes($bytes, $precision = 2) {
        $units = ['B', 'KB', 'MB', 'GB', 'TB'];
        $bytes = max($bytes, 0);
        $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
        $pow = min($pow, count($units) - 1);
        $bytes /= pow(1024, $pow);
        
        return round($bytes, $precision) . ' ' . $units[$pow];
    }
}
?>