<main class="main-content" id="mainContent">
    <header class="main-header">
        <h1>CREATE NEW PROJECT</h1>
        <p class="welcome-text">Start by naming your project and adding a description</p>
    </header>

    <div class="content-area">
        <!-- Display Messages -->
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <?php echo $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>
        
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>

        <div class="project-creation-form">
            <form action="<?php echo site_url('project/save_project'); ?>" method="post" id="projectForm">
                <div class="form-group">
                    <label for="project_name" class="form-label">
                        Project Name *
                    </label>
                    <input type="text" id="project_name" name="project_name" required
                           class="form-input"
                           placeholder="Enter project name (e.g., Summer Campaign 2024)">
                </div>

                <div class="form-group">
                    <label for="project_description" class="form-label">
                        Project Description
                    </label>
                    <textarea id="project_description" name="project_description" rows="4"
                              class="form-textarea"
                              placeholder="Describe your project (optional)"></textarea>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        Create Project & Continue
                    </button>
                    <a href="<?php echo site_url('project'); ?>" class="btn btn-secondary">
                        Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>
</main>

<script>
document.getElementById('projectForm').addEventListener('submit', function(e) {
    const submitBtn = this.querySelector('button[type="submit"]');
    submitBtn.disabled = true;
    submitBtn.innerHTML = 'Creating Project...';
});
</script>