<main class="main-content" id="mainContent">
    <header class="main-header">
        <div>
            <h1><?php echo strtoupper($page_title); ?></h1>
            <p class="welcome-text">Manage all your PDF processing projects</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo site_url('project/create'); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create New Project
            </a>
        </div>
    </header>

    <section class="content-area">
        <!-- Projects Grid -->
        <?php if (!empty($projects)): ?>
            <div class="projects-grid">
                <?php foreach ($projects as $project): 
                    // Get project stats
                    $pdf_count = $this->db->where('project_id', $project->id)->count_all_results('project_pdfs');
                    $model_count = $this->db->where('project_id', $project->id)->count_all_results('extracted_data');
                    $image_count = $this->db->where('project_id', $project->id)->count_all_results('extracted_images');
                ?>
                    <div class="project-card">
                        <div class="project-header">
                            <div class="project-title-section">
                                <h3 class="project-title"><?php echo htmlspecialchars($project->name); ?></h3>
                                <span class="project-status status-<?php echo $project->status; ?>">
                                    <?php echo ucfirst($project->status); ?>
                                </span>
                            </div>
                            <div class="project-actions">
                                <button class="btn-icon" onclick="deleteProject('<?php echo $project->id; ?>', '<?php echo htmlspecialchars($project->name); ?>')" title="Delete Project">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                        
                        <div class="project-content">
                            <?php if (!empty($project->description)): ?>
                                <p class="project-description"><?php echo htmlspecialchars($project->description); ?></p>
                            <?php endif; ?>
                            
                            <div class="project-stats">
                                <div class="stat-item">
                                    <i class="fas fa-file-pdf"></i>
                                    <span><?php echo $pdf_count; ?> PDFs</span>
                                </div>
                                <div class="stat-item">
                                    <i class="fas fa-users"></i>
                                    <span><?php echo $model_count; ?> Models</span>
                                </div>
                                <div class="stat-item">
                                    <i class="fas fa-images"></i>
                                    <span><?php echo $image_count; ?> Images</span>
                                </div>
                            </div>
                            
                            <div class="project-meta">
                                <div class="meta-item">
                                    <i class="fas fa-calendar"></i>
                                    <span><?php echo date('M j, Y g:i A', strtotime($project->created_at)); ?></span>
                                </div>
                                <div class="meta-item">
                                    <i class="fas fa-fingerprint"></i>
                                    <span class="project-id"><?php echo $project->id; ?></span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="project-actions-footer">
                            <a href="<?php echo site_url('project/view/' . $project->id); ?>" class="btn btn-secondary">
                                <i class="fas fa-eye"></i> View Project
                            </a>
                            <a href="<?php echo site_url('project/upload/' . $project->id); ?>" class="btn btn-primary">
                                <i class="fas fa-upload"></i> Upload PDFs
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="empty-state">
                <div class="empty-icon">
                    <i class="fas fa-folder-open"></i>
                </div>
                <h3>No Projects Yet</h3>
                <p>Create your first project to start processing PDFs and extracting model information</p>
                <a href="<?php echo site_url('project/create'); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create Your First Project
                </a>
            </div>
        <?php endif; ?>
    </section>
</main>

<!-- Delete Confirmation Modal -->
<div id="deleteProjectModal" class="modal" style="display: none;">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Delete Project</h3>
            <button class="btn-close" onclick="closeDeleteModal()">&times;</button>
        </div>
        <div class="modal-body">
            <p>Are you sure you want to delete project "<span id="projectNameToDelete"></span>"?</p>
            <p class="warning-text">This action will permanently delete all project data, PDFs, images, and model information. This cannot be undone.</p>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" onclick="closeDeleteModal()">Cancel</button>
            <button class="btn btn-danger" id="confirmDeleteBtn">Delete Project</button>
        </div>
    </div>
</div>