<main class="main-content" id="mainContent">
    <header class="main-header">
        <h1>UPLOAD PDFs: <?php echo strtoupper($project->name); ?></h1>
        <p class="welcome-text">Upload portfolio PDFs in bulk (up to 100 files at once)</p>
    </header>

    <div class="content-area">
        <!-- Project Info -->
        <div class="project-info-card">
            <h3>Project Information</h3>
            <div class="project-info-grid">
                <div class="info-item">
                    <strong>Project ID:</strong> <?php echo $project->id; ?>
                </div>
                <div class="info-item">
                    <strong>Name:</strong> <?php echo $project->name; ?>
                </div>
                <?php if (!empty($project->description)): ?>
                <div class="info-item">
                    <strong>Description:</strong> <?php echo $project->description; ?>
                </div>
                <?php endif; ?>
                <div class="info-item">
                    <strong>Created:</strong> <?php echo date('M j, Y g:i A', strtotime($project->created_at)); ?>
                </div>
            </div>
        </div>

        <!-- Upload Area -->
        <div id="uploadSection" class="upload-area">
            <i class="fas fa-cloud-upload-alt upload-icon"></i>
            <h3>Drag & Drop Your PDFs Here</h3>
            <p class="upload-description">Upload multiple PDF files at once (up to 100 files)</p>
            
            <form action="<?php echo site_url('project/process_upload/' . $project->id); ?>" method="post" enctype="multipart/form-data" id="uploadForm">
                <input type="file" name="pdf_files[]" multiple accept=".pdf" required 
                       id="pdfFiles" class="file-input" onchange="handleFileSelect(this)">
                
                <button type="button" onclick="document.getElementById('pdfFiles').click()" 
                        class="btn btn-primary upload-btn">
                    Select PDF Files
                </button>
                
                <div id="fileInfo" class="file-info"></div>
                
                <div id="uploadActions" class="upload-actions">
                    <button type="submit" id="processBtn" class="btn btn-success">
                        Process PDFs
                    </button>
                    <button type="button" onclick="clearSelection()" class="btn btn-secondary">
                        Clear Selection
                    </button>
                </div>
            </form>
        </div>

        <!-- Processing Progress -->
        <div id="processingSection" class="processing-section">
            <h3>Processing PDFs...</h3>
            <div class="progress-container">
                <div id="progressBar" class="progress-bar">
                    <div id="progressFill" class="progress-fill"></div>
                </div>
                <div id="progressText" class="progress-text">0%</div>
                <div id="progressDetails" class="progress-details"></div>
            </div>
        </div>

        <!-- Features -->
        <div class="features-section">
            <h3>What happens next?</h3>
            <div class="features-grid">
                <div class="feature-item">
                    <i class="fas fa-sync-alt feature-icon"></i>
                    <h4>Auto Extraction</h4>
                    <p>Automatically extract model information, images, and text from PDFs</p>
                </div>
                <div class="feature-item">
                    <i class="fas fa-images feature-icon"></i>
                    <h4>Image Conversion</h4>
                    <p>Convert all images to WebP format for better performance</p>
                </div>
                <div class="feature-item">
                    <i class="fas fa-database feature-icon"></i>
                    <h4>Database Storage</h4>
                    <p>Store all extracted data in organized database tables</p>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
let selectedFiles = [];

function handleFileSelect(input) {
    selectedFiles = Array.from(input.files);
    updateFileInfo();
}

function updateFileInfo() {
    const fileInfo = document.getElementById('fileInfo');
    const uploadActions = document.getElementById('uploadActions');
    
    if (selectedFiles.length > 0) {
        const fileList = selectedFiles.map(file => 
            `<div class="file-item">${file.name} (${(file.size/1024/1024).toFixed(2)} MB)</div>`
        ).join('');
        
        fileInfo.innerHTML = `
            <div class="file-list">
                <h4>Selected Files (${selectedFiles.length}):</h4>
                <div class="file-list-container">${fileList}</div>
            </div>
        `;
        uploadActions.style.display = 'flex';
    } else {
        fileInfo.innerHTML = '';
        uploadActions.style.display = 'none';
    }
}

function clearSelection() {
    document.getElementById('pdfFiles').value = '';
    selectedFiles = [];
    updateFileInfo();
}

document.getElementById('uploadForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    if (selectedFiles.length === 0) {
        alert('Please select at least one PDF file.');
        return;
    }
    
    // Show processing section
    document.getElementById('uploadSection').style.display = 'none';
    document.getElementById('processingSection').style.display = 'block';
    
    // Simulate progress updates
    simulateProgress();
    
    // Submit form
    this.submit();
});

function simulateProgress() {
    let progress = 0;
    const progressFill = document.getElementById('progressFill');
    const progressText = document.getElementById('progressText');
    const progressDetails = document.getElementById('progressDetails');
    
    const interval = setInterval(() => {
        progress += Math.random() * 10;
        if (progress >= 100) {
            progress = 100;
            clearInterval(interval);
            progressDetails.innerHTML = 'Processing completed! Redirecting...';
        } else {
            progressDetails.innerHTML = `Processing ${selectedFiles.length} files...`;
        }
        
        progressFill.style.width = progress + '%';
        progressText.textContent = Math.round(progress) + '%';
    }, 500);
}

// Drag and drop functionality
const uploadSection = document.getElementById('uploadSection');
uploadSection.addEventListener('dragover', (e) => {
    e.preventDefault();
    uploadSection.classList.add('drag-over');
});

uploadSection.addEventListener('dragleave', (e) => {
    e.preventDefault();
    uploadSection.classList.remove('drag-over');
});

uploadSection.addEventListener('drop', (e) => {
    e.preventDefault();
    uploadSection.classList.remove('drag-over');
    
    const files = e.dataTransfer.files;
    document.getElementById('pdfFiles').files = files;
    handleFileSelect(document.getElementById('pdfFiles'));
});
</script>