    </div> <!-- Close dashboard-container -->

    <!-- Simple Transparent Footer -->
    <footer class="main-footer">
        <div class="footer-content">
            <div class="footer-copyright">
                &copy; 2025 GO Productions | All Rights Reserved
            </div>
        </div>
    </footer>

    <!-- Delete Confirmation Modal -->
    <div id="deleteProjectModal" class="modal" style="display: none;">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Delete Project</h3>
                <button class="btn-close" onclick="closeDeleteModal()">&times;</button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete project "<span id="projectNameToDelete"></span>"?</p>
                <p class="warning-text">This action will permanently delete all project data, PDFs, images, and model information. This cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" onclick="closeDeleteModal()">Cancel</button>
                <button class="btn btn-danger" id="confirmDeleteBtn">Delete Project</button>
            </div>
        </div>
    </div>

    <script>
        let projectToDelete = null;

        function deleteProject(projectId, projectName) {
            projectToDelete = projectId;
            document.getElementById('projectNameToDelete').textContent = projectName;
            document.getElementById('deleteProjectModal').style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }

        function closeDeleteModal() {
            projectToDelete = null;
            document.getElementById('deleteProjectModal').style.display = 'none';
            document.body.style.overflow = 'auto';
        }

        document.getElementById('confirmDeleteBtn').addEventListener('click', function() {
            if (projectToDelete) {
                deleteProjectConfirmed(projectToDelete);
            }
        });

        async function deleteProjectConfirmed(projectId) {
            try {
                const response = await fetch('<?php echo site_url('project/delete_project/'); ?>' + projectId, {
                    method: 'DELETE',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                });
                
                const data = await response.json();
                
                if (data.success) {
                    showNotification('Project deleted successfully!', 'success');
                    closeDeleteModal();
                    // Add slight delay for better UX
                    setTimeout(() => {
                        location.reload();
                    }, 1000);
                } else {
                    showNotification('Failed to delete project: ' + (data.message || 'Unknown error'), 'error');
                }
            } catch (error) {
                showNotification('Error deleting project: ' + error.message, 'error');
            }
        }

        // Close modal when clicking outside or pressing Escape
        document.getElementById('deleteProjectModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeDeleteModal();
            }
        });

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeDeleteModal();
            }
        });

        // Notification function
        function showNotification(message, type) {
            const notification = document.createElement('div');
            notification.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                padding: 12px 20px;
                border-radius: 8px;
                color: white;
                font-weight: 600;
                z-index: 1001;
                transform: translateX(100%);
                transition: transform 0.3s ease;
                max-width: 300px;
            `;
            
            if (type === 'success') {
                notification.style.background = '#28a745';
            } else {
                notification.style.background = '#dc3545';
            }
            
            notification.textContent = message;
            document.body.appendChild(notification);
            
            // Animate in
            setTimeout(() => {
                notification.style.transform = 'translateX(0)';
            }, 100);
            
            // Remove after 3 seconds
            setTimeout(() => {
                notification.style.transform = 'translateX(100%)';
                setTimeout(() => {
                    document.body.removeChild(notification);
                }, 300);
            }, 3000);
        }

        // Auto-minimize sidebar on hover
        let sidebarTimeout;
        const sidebar = document.getElementById('sidebar');

        function expandSidebar() {
            clearTimeout(sidebarTimeout);
            sidebar.classList.remove('collapsed');
        }

        function collapseSidebar() {
            sidebarTimeout = setTimeout(() => {
                sidebar.classList.add('collapsed');
            }, 500); // 500ms delay before collapsing
        }

        // Add event listeners for auto-minimize
        sidebar.addEventListener('mouseenter', expandSidebar);
        sidebar.addEventListener('mouseleave', collapseSidebar);

        // Manual toggle function
        function toggleSidebar() {
            sidebar.classList.toggle('collapsed');
            
            // Update the icon
            const icon = document.querySelector('.toggle-sidebar i');
            if (sidebar.classList.contains('collapsed')) {
                icon.className = 'fas fa-chevron-right';
            } else {
                icon.className = 'fas fa-chevron-left';
            }
        }

        // Add hover delay for better UX
        let hoverTimer;
        const projectCards = document.querySelectorAll('.project-card');

        projectCards.forEach(card => {
            card.addEventListener('mouseenter', function() {
                clearTimeout(hoverTimer);
                this.style.zIndex = '10';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.zIndex = '1';
            });
        });

        <?php if (isset($page_title) && $page_title == 'Dashboard' && isset($analytics)): ?>
        document.addEventListener('DOMContentLoaded', function() {
            const labels = <?php echo isset($analytics['labels']) ? json_encode($analytics['labels']) : json_encode([]); ?>;
            const primaryData = <?php echo isset($analytics['primary_data']) ? json_encode($analytics['primary_data']) : json_encode([]); ?>;
            const secondaryData = <?php echo isset($analytics['secondary_data']) ? json_encode($analytics['secondary_data']) : json_encode([]); ?>;

            const ctx = document.getElementById('myLineChart').getContext('2d');

            const chart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: [
                        {
                            label: 'Primary Trend',
                            data: primaryData,
                            borderColor: '#007bff',
                            backgroundColor: 'rgba(0, 123, 255, 0.1)',
                            fill: false,
                            tension: 0.4,
                            pointRadius: 4,
                            pointBackgroundColor: '#007bff'
                        },
                        {
                            label: 'Secondary Trend',
                            data: secondaryData,
                            borderColor: '#ccc',
                            backgroundColor: 'rgba(204, 204, 204, 0.1)',
                            fill: false,
                            tension: 0.4,
                            pointRadius: 2,
                            pointBackgroundColor: '#ccc'
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                color: 'rgba(0, 0, 0, 0.05)'
                            },
                            ticks: {
                                callback: function(value) {
                                    return value.toLocaleString();
                                },
                                font: {
                                    size: 12
                                }
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });
        });
        <?php endif; ?>
    </script>
</body>
</html>