<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GO Productions - <?php echo isset($page_title) ? $page_title : 'Admin'; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.28/jspdf.plugin.autotable.min.js"></script>
<!-- For better image handling -->
<script src="https://unpkg.com/canvg/dist/canvg.min.js"></script>
    <style>
        :root {
            --sidebar-bg: #000000;
            --main-bg: #f4f7f9;
            --text-color: #333333;
            --light-text: #6c757d;
            --positive-color: #28a745;
            --negative-color: #dc3545;
            --primary-color: #007bff;
            --card-bg: #ffffff;
            --white: #ffffff;
            --black: #000000;
            --border-color: #e0e0e0;
            --hover-color: #f8f9fa;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', -apple-system, BlinkMacSystemFont, 'Roboto', 'Oxygen', 'Ubuntu', 'Cantarell', sans-serif;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        body {
            background-color: var(--main-bg);
            overflow-x: hidden;
        }

        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }

        /* Main Content */
        .main-content {
            flex-grow: 1;
            background-color: var(--main-bg);
            padding: 30px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .main-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
        }

        .main-header h1 {
            font-size: 32px;
            color: var(--text-color);
            margin-bottom: 8px;
            font-weight: 800;
            letter-spacing: -0.5px;
        }

        .welcome-text {
            font-size: 15px;
            color: var(--light-text);
            font-weight: 500;
        }

        .header-actions {
            display: flex;
            gap: 15px;
        }

        /* Button Styles */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            padding: 12px 20px;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            text-decoration: none;
            cursor: pointer;
            transition: all 0.3s ease;
            text-align: center;
            line-height: 1;
        }

        .btn-primary {
            background: var(--black);
            color: var(--white);
            border: 2px solid var(--black);
        }

        .btn-primary:hover {
            background: #333;
            border-color: #333;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        }

        .btn-secondary {
            background: transparent;
            color: var(--text-color);
            border: 2px solid var(--border-color);
        }

        .btn-secondary:hover {
            background: var(--border-color);
            border-color: var(--text-color);
            transform: translateY(-2px);
        }

        .btn-danger {
            background: #dc3545;
            color: white;
            border: 2px solid #dc3545;
        }

        .btn-danger:hover {
            background: #c82333;
            border-color: #c82333;
            transform: translateY(-2px);
        }

        .btn-sm {
            padding: 8px 16px;
            font-size: 12px;
        }

        .btn-icon {
            background: none;
            border: 1px solid var(--border-color);
            border-radius: 6px;
            padding: 6px;
            cursor: pointer;
            transition: all 0.3s ease;
            color: var(--light-text);
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .btn-icon:hover {
            background: #ffebee;
            color: #dc3545;
            border-color: #dc3545;
            transform: scale(1.1);
        }

        /* Content Area */
        .content-area {
            background-color: var(--card-bg);
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            flex-grow: 1;
        }

        /* Projects Grid Styles */
        .projects-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }

        .project-card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            height: fit-content;
            max-height: 200px;
        }

        .project-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 30px rgba(0,0,0,0.15);
            max-height: 400px;
            transition: max-height 0.5s ease, transform 0.3s ease;
        }

        .project-card:hover .project-content {
            opacity: 1;
            transform: translateY(0);
        }

        .project-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 12px;
        }

        .project-title-section {
            flex: 1;
            min-width: 0;
        }

        .project-title {
            font-size: 16px;
            font-weight: 700;
            color: var(--text-color);
            margin: 0 0 6px 0;
            line-height: 1.3;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .project-status {
            padding: 3px 10px;
            border-radius: 16px;
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
            display: inline-block;
        }

        .status-created { background: #f0f0f0; color: #666; }
        .status-processing { background: #fff3e0; color: #e65100; }
        .status-completed { background: #e8f5e8; color: #2e7d32; }
        .status-failed { background: #ffebee; color: #c62828; }

        .project-actions {
            display: flex;
            gap: 6px;
            flex-shrink: 0;
        }

        .project-content {
            opacity: 0.7;
            transform: translateY(5px);
            transition: all 0.3s ease;
        }

        .project-card:hover .project-content {
            opacity: 1;
            transform: translateY(0);
        }

        .project-description {
            color: var(--light-text);
            font-size: 13px;
            line-height: 1.4;
            margin-bottom: 15px;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .project-card:hover .project-description {
            -webkit-line-clamp: unset;
            overflow: visible;
        }

        .project-stats {
            display: flex;
            gap: 15px;
            margin-bottom: 15px;
            padding: 12px 0;
            border-top: 1px solid var(--border-color);
            border-bottom: 1px solid var(--border-color);
        }

        .stat-item {
            display: flex;
            align-items: center;
            gap: 6px;
            font-size: 12px;
            color: var(--light-text);
            flex: 1;
            justify-content: center;
        }

        .stat-item i {
            width: 14px;
            text-align: center;
            color: var(--text-color);
            font-size: 13px;
        }

        .project-meta {
            display: flex;
            flex-direction: column;
            gap: 6px;
            margin-bottom: 15px;
        }

        .meta-item {
            display: flex;
            align-items: center;
            gap: 6px;
            font-size: 11px;
            color: var(--light-text);
        }

        .meta-item i {
            width: 12px;
            text-align: center;
            font-size: 11px;
        }

        .project-id {
            font-family: 'Courier New', monospace;
            background: #f5f5f5;
            padding: 2px 6px;
            border-radius: 4px;
            font-size: 10px;
            letter-spacing: -0.5px;
        }

        .project-actions-footer {
            display: flex;
            gap: 8px;
            margin-top: 15px;
        }

        .project-actions-footer .btn {
            flex: 1;
            padding: 8px 12px;
            font-size: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 4px;
            min-height: 36px;
        }

        .project-actions-footer .btn i {
            font-size: 11px;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 60px 30px;
            background: var(--card-bg);
            border: 2px dashed var(--border-color);
            border-radius: 12px;
            max-width: 500px;
            margin: 0 auto;
        }

        .empty-icon {
            font-size: 48px;
            color: var(--light-text);
            margin-bottom: 16px;
            opacity: 0.5;
        }

        .empty-state h3 {
            color: var(--text-color);
            margin-bottom: 10px;
            font-weight: 600;
            font-size: 18px;
        }

        .empty-state p {
            color: var(--light-text);
            margin-bottom: 25px;
            line-height: 1.5;
        }

        .empty-state .btn {
            padding: 12px 30px;
        }

        /* Modal Styles */
        .modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
            backdrop-filter: blur(2px);
        }

        .modal-content {
            background: var(--card-bg);
            border-radius: 12px;
            width: 90%;
            max-width: 450px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            border: 1px solid var(--border-color);
        }

        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid var(--border-color);
        }

        .modal-header h3 {
            margin: 0;
            color: var(--text-color);
            font-weight: 700;
            font-size: 18px;
        }

        .btn-close {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: var(--light-text);
            padding: 0;
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 4px;
            transition: all 0.3s ease;
        }

        .btn-close:hover {
            background: #f0f0f0;
            transform: rotate(90deg);
        }

        .modal-body {
            padding: 20px;
        }

        .modal-body p {
            margin: 0 0 12px 0;
            color: var(--text-color);
            line-height: 1.5;
            font-size: 14px;
        }

        .warning-text {
            color: #dc3545 !important;
            font-weight: 600;
            background: #ffebee;
            padding: 12px;
            border-radius: 6px;
            border-left: 4px solid #dc3545;
            font-size: 13px;
            margin: 0;
        }

        .modal-footer {
            padding: 16px 20px;
            border-top: 1px solid var(--border-color);
            display: flex;
            gap: 10px;
            justify-content: flex-end;
        }
        
/* Form Styles */
.form-group {
    margin-bottom: 20px;
}

.form-label {
    display: block;
    margin-bottom: 5px;
    font-weight: 600;
    color: var(--text-color);
}

.form-input,
.form-textarea,
.form-select {
    width: 100%;
    padding: 12px;
    border: 1px solid var(--border-color);
    border-radius: 6px;
    background: var(--card-bg);
    color: var(--text-color);
    font-size: 14px;
    transition: border-color 0.3s ease;
}

.form-input:focus,
.form-textarea:focus,
.form-select:focus {
    outline: none;
    border-color: var(--black);
}

.form-textarea {
    resize: vertical;
    min-height: 100px;
}

.form-actions {
    display: flex;
    gap: 10px;
    margin-top: 25px;
}

/* Alert Styles */
.alert {
    padding: 15px;
    border-radius: 6px;
    margin-bottom: 20px;
    font-weight: 500;
}

.alert-success {
    background: #f0f9f0;
    color: #2e7d32;
    border: 1px solid #c8e6c9;
}

.alert-danger {
    background: #ffebee;
    color: #c62828;
    border: 1px solid #ffcdd2;
}

/* Search Page Styles */
.search-header {
    background: var(--card-bg);
    padding: 30px;
    border-radius: 12px;
    margin-bottom: 30px;
    border: 1px solid var(--border-color);
}

.search-header-content {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 30px;
    align-items: start;
}

.search-input-section h3 {
    margin-bottom: 15px;
    font-weight: 600;
    color: var(--text-color);
}

.search-container {
    position: relative;
}

.search-input {
    width: 100%;
    padding: 15px 50px 15px 20px;
    border: 1px solid var(--border-color);
    border-radius: 8px;
    background: var(--card-bg);
    color: var(--text-color);
    font-size: 16px;
}

.search-icon {
    position: absolute;
    right: 20px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--light-text);
    font-size: 18px;
}

.quick-stats {
    background: rgba(0, 0, 0, 0.05);
    padding: 20px;
    border-radius: 8px;
}

.quick-stats h4 {
    margin-bottom: 15px;
    font-weight: 600;
    color: var(--text-color);
}

.stats-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 15px;
}

.stat-box {
    text-align: center;
}

.stat-value {
    font-size: 24px;
    font-weight: 700;
    color: var(--text-color);
}

.stat-label {
    font-size: 12px;
    color: var(--light-text);
}

/* Filters Section */
.filters-section {
    background: var(--card-bg);
    padding: 25px;
    border-radius: 12px;
    margin-bottom: 30px;
    border: 1px solid var(--border-color);
}

.filters-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.filters-header h3 {
    margin: 0;
    color: var(--text-color);
}

.filters-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
}

.filter-group {
    margin-bottom: 0;
}

.filter-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: var(--text-color);
}

.filter-select {
    width: 100%;
    padding: 10px;
    border: 1px solid var(--border-color);
    border-radius: 6px;
    background: var(--card-bg);
    color: var(--text-color);
}

/* Active Filters */
.active-filters {
    display: none;
    margin-top: 20px;
    padding-top: 20px;
    border-top: 1px solid var(--border-color);
    align-items: center;
    gap: 10px;
    flex-wrap: wrap;
}

.active-filters-label {
    font-weight: 600;
    color: var(--text-color);
}

.filter-tags {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
}

.filter-tag {
    background: var(--border-color);
    color: var(--text-color);
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 12px;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}

.filter-tag-remove {
    background: none;
    border: none;
    color: var(--text-color);
    cursor: pointer;
    font-size: 14px;
    padding: 0;
    width: 16px;
    height: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Results Section */
.results-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.results-header h3 {
    margin: 0;
    color: var(--text-color);
}

.results-count {
    font-size: 14px;
    color: var(--light-text);
    margin-left: 10px;
}

.sort-controls {
    display: flex;
    gap: 10px;
    align-items: center;
}

.sort-label {
    font-size: 14px;
    color: var(--light-text);
}

.sort-select {
    padding: 8px 12px;
    border: 1px solid var(--border-color);
    border-radius: 6px;
    background: var(--card-bg);
    color: var(--text-color);
}

/* Loading State */
.loading-state {
    display: none;
    text-align: center;
    padding: 40px;
}

.spinner {
    width: 3rem;
    height: 3rem;
    border: 2px solid var(--border-color);
    border-top: 2px solid var(--black);
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 15px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.loading-state p {
    margin-top: 15px;
    color: var(--light-text);
}

/* No Results State */
.no-results {
    display: none;
    text-align: center;
    padding: 60px 20px;
}

.no-results-icon {
    font-size: 64px;
    margin-bottom: 20px;
}

.no-results h4 {
    color: var(--light-text);
    margin-bottom: 10px;
}

.no-results p {
    color: var(--light-text);
    margin-bottom: 20px;
}

/* Search Results Cards */
.search-result-card {
    background: var(--card-bg);
    border-radius: 12px;
    padding: 25px;
    border: 1px solid var(--border-color);
    transition: all 0.3s ease;
}

.search-result-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 30px rgba(0,0,0,0.12);
}

.models-section {
    margin-bottom: 20px;
}

.models-section h5 {
    margin-bottom: 10px;
    color: var(--text-color);
}

.models-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
}

.model-tag {
    background: var(--border-color);
    padding: 4px 8px;
    border-radius: 6px;
    font-size: 12px;
    color: var(--text-color);
}

.more-models {
    background: var(--border-color);
    padding: 4px 8px;
    border-radius: 6px;
    font-size: 12px;
    color: var(--light-text);
}

/* Upload Page Styles */
.project-info-card {
    background: var(--card-bg);
    padding: 20px;
    border-radius: 8px;
    margin-bottom: 30px;
    border: 1px solid var(--border-color);
}

.project-info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 10px;
}

.info-item {
    padding: 5px 0;
}

.upload-area {
    border: 2px dashed var(--border-color);
    border-radius: 8px;
    padding: 40px;
    text-align: center;
    background: var(--card-bg);
    transition: all 0.3s ease;
}

.upload-area.drag-over {
    border-color: var(--black);
    background: rgba(0, 0, 0, 0.02);
}

.upload-icon {
    font-size: 48px;
    color: var(--light-text);
    margin-bottom: 20px;
    opacity: 0.7;
}

.upload-description {
    color: var(--light-text);
    margin-bottom: 20px;
}

.file-input {
    display: none;
}

.upload-btn {
    padding: 12px 30px;
}

.file-info {
    margin-top: 20px;
}

.file-list h4 {
    margin-bottom: 10px;
    color: var(--text-color);
}

.file-list-container {
    max-height: 200px;
    overflow-y: auto;
}

.file-item {
    padding: 8px;
    background: var(--border-color);
    margin: 4px 0;
    border-radius: 4px;
    font-size: 14px;
}

.upload-actions {
    display: none;
    margin-top: 20px;
    gap: 10px;
    justify-content: center;
}

.processing-section {
    display: none;
    margin-top: 30px;
}

.progress-container {
    background: var(--card-bg);
    border-radius: 8px;
    padding: 20px;
    border: 1px solid var(--border-color);
}

.progress-bar {
    height: 20px;
    background: var(--border-color);
    border-radius: 10px;
    overflow: hidden;
    margin-bottom: 10px;
}

.progress-fill {
    height: 100%;
    background: var(--black);
    width: 0%;
    transition: width 0.3s;
}

.progress-text {
    text-align: center;
    font-weight: bold;
    color: var(--text-color);
}

.progress-details {
    text-align: center;
    color: var(--light-text);
    margin-top: 10px;
}

.features-section {
    margin-top: 40px;
    padding: 20px;
    background: var(--card-bg);
    border-radius: 8px;
    border: 1px solid var(--border-color);
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-top: 15px;
}

.feature-item {
    text-align: center;
}

.feature-icon {
    font-size: 24px;
    color: var(--light-text);
    margin-bottom: 10px;
}

.feature-item h4 {
    margin-bottom: 8px;
    color: var(--text-color);
}

.feature-item p {
    color: var(--light-text);
    line-height: 1.5;
}

/* Search Suggestions */
.search-suggestions {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 8px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
    z-index: 1000;
    max-height: 300px;
    overflow-y: auto;
    display: none;
}

.suggestion-item {
    padding: 12px 15px;
    cursor: pointer;
    border-bottom: 1px solid var(--border-color);
    transition: background-color 0.2s ease;
}

.suggestion-item:hover {
    background-color: var(--hover-color);
}

.suggestion-item:last-child {
    border-bottom: none;
}

.suggestion-title {
    font-weight: 600;
    color: var(--text-color);
}

.suggestion-models {
    font-size: 12px;
    color: var(--light-text);
    margin-top: 4px;
}

/* Mark highlight */
mark {
    background: #ffeb3b;
    padding: 2px 0;
}

/* Responsive Design */
@media (max-width: 768px) {
    .search-header-content {
        grid-template-columns: 1fr;
        gap: 20px;
    }
    
    .filters-grid {
        grid-template-columns: 1fr;
    }
    
    .results-header {
        flex-direction: column;
        gap: 15px;
        align-items: flex-start;
    }
    
    .sort-controls {
        width: 100%;
        justify-content: space-between;
    }
    
    .project-info-grid {
        grid-template-columns: 1fr;
    }
    
    .features-grid {
        grid-template-columns: 1fr;
    }
    
    .upload-area {
        padding: 20px;
    }
}
        .modal-footer .btn {
            padding: 10px 20px;
            font-size: 13px;
            min-width: 80px;
        }

        /* Footer */
        .main-footer {
            background-color: var(--black);
            color: var(--white);
            padding: 20px 30px;
            text-align: center;
            margin-top: auto;
        }
        /* Admin Dashboard - Black & White Theme */
:root {
    --sidebar-bg: #000000;
    --main-bg: #f8f9fa;
    --text-color: #333333;
    --light-text: #6c757d;
    --positive-color: #28a745;
    --negative-color: #dc3545;
    --primary-color: #007bff;
    --card-bg: #ffffff;
    --white: #ffffff;
    --black: #000000;
    --border-color: #e0e0e0;
    --hover-color: #f8f9fa;
    --success-color: #28a745;
    --warning-color: #ffc107;
    --danger-color: #dc3545;
    --info-color: #17a2b8;
}

* {
    box-sizing: border-box;
    margin: 0;
    padding: 0;
    font-family: 'Segoe UI', -apple-system, BlinkMacSystemFont, 'Roboto', 'Oxygen', 'Ubuntu', 'Cantarell', sans-serif;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

body {
    background-color: var(--main-bg);
    overflow-x: hidden;
}

.dashboard-container {
    display: flex;
    min-height: 100vh;
}

/* Main Content */
.main-content {
    flex-grow: 1;
    background-color: var(--main-bg);
    padding: 30px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    min-height: 100vh;
    display: flex;
    flex-direction: column;
}

.main-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 30px;
}

.main-header h1 {
    font-size: 32px;
    color: var(--text-color);
    margin-bottom: 8px;
    font-weight: 800;
    letter-spacing: -0.5px;
}

.welcome-text {
    font-size: 15px;
    color: var(--light-text);
    font-weight: 500;
}

.header-actions {
    display: flex;
    gap: 15px;
}

/* Button Styles */
.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 20px;
    border: none;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 600;
    text-decoration: none;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: center;
    line-height: 1;
}

.btn-primary {
    background: var(--black);
    color: var(--white);
    border: 2px solid var(--black);
}

.btn-primary:hover {
    background: #333;
    border-color: #333;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

.btn-secondary {
    background: transparent;
    color: var(--text-color);
    border: 2px solid var(--border-color);
}

.btn-secondary:hover {
    background: var(--border-color);
    border-color: var(--text-color);
    transform: translateY(-2px);
}

.btn-danger {
    background: var(--danger-color);
    color: white;
    border: 2px solid var(--danger-color);
}

.btn-danger:hover {
    background: #c82333;
    border-color: #c82333;
    transform: translateY(-2px);
}

.btn-warning {
    background: var(--warning-color);
    color: var(--black);
    border: 2px solid var(--warning-color);
}

.btn-warning:hover {
    background: #e0a800;
    border-color: #e0a800;
    transform: translateY(-2px);
}

.btn-sm {
    padding: 8px 16px;
    font-size: 12px;
}

.btn-icon {
    background: none;
    border: 1px solid var(--border-color);
    border-radius: 6px;
    padding: 6px;
    cursor: pointer;
    transition: all 0.3s ease;
    color: var(--light-text);
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.btn-icon:hover {
    background: var(--hover-color);
    color: var(--text-color);
    border-color: var(--text-color);
    transform: scale(1.1);
}

/* Content Area */
.content-area {
    background-color: var(--card-bg);
    padding: 30px;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    flex-grow: 1;
}

/* Metrics Cards */
.metrics-cards {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 20px;
    margin-bottom: 30px;
}

.stat-card {
    background: linear-gradient(135deg, var(--card-bg) 0%, #f8f9fa 100%);
    border-radius: 16px;
    padding: 24px;
    box-shadow: 0 8px 32px rgba(0,0,0,0.1);
    border: 1px solid rgba(255,255,255,0.2);
    display: flex;
    align-items: center;
    gap: 16px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 12px 40px rgba(0,0,0,0.15);
}

.card-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 24px;
}

.card-content {
    flex: 1;
}

.card-label {
    font-size: 14px;
    color: var(--light-text);
    margin-bottom: 8px;
    font-weight: 600;
}

.card-data {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.value {
    font-size: 32px;
    font-weight: 800;
    color: var(--text-color);
    letter-spacing: -0.5px;
}

.change {
    font-size: 12px;
    font-weight: 700;
    padding: 4px 8px;
    border-radius: 12px;
}

.change.positive {
    background: #e8f5e8;
    color: #2e7d32;
}

.change.negative {
    background: #ffebee;
    color: #c62828;
}

/* Analytics Grid */
.analytics-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 24px;
    margin-bottom: 30px;
}

.analytics-column {
    display: flex;
    flex-direction: column;
    gap: 24px;
}

/* Chart Cards */
.chart-card {
    background-color: var(--card-bg);
    border-radius: 16px;
    padding: 24px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    border: 1px solid var(--border-color);
}

.chart-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.chart-header h3 {
    font-size: 18px;
    font-weight: 700;
    color: var(--text-color);
    margin: 0;
}

.chart-container {
    height: 300px;
    position: relative;
}

/* Status Indicators */
.status-indicator {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
}

.status-dot {
    width: 8px;
    height: 8px;
    border-radius: 50%;
}

.status-dot.healthy { background: #4caf50; }
.status-dot.warning { background: #ff9800; }
.status-dot.error { background: #f44336; }
.status-dot.checking { 
    background: #666;
    animation: pulse 1.5s infinite;
}

@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.5; }
    100% { opacity: 1; }
}

/* Activity List */
.activity-list {
    max-height: 400px;
    overflow-y: auto;
}

.activity-item {
    display: flex;
    align-items: flex-start;
    gap: 16px;
    padding: 20px;
    border-bottom: 1px solid var(--border-color);
    transition: background-color 0.3s ease;
}

.activity-item:hover {
    background-color: var(--hover-color);
}

.activity-item:last-child {
    border-bottom: none;
}

.activity-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
    flex-shrink: 0;
}

.activity-content {
    flex: 1;
}

.activity-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-color);
    margin-bottom: 4px;
}

.activity-description {
    font-size: 14px;
    color: var(--light-text);
    margin-bottom: 8px;
}

.activity-meta {
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 12px;
}

.user-badge {
    background: var(--border-color);
    padding: 4px 8px;
    border-radius: 12px;
    color: var(--text-color);
    font-weight: 600;
}

.activity-time {
    color: var(--light-text);
}

/* Form Styles */
.form-group {
    margin-bottom: 20px;
}

.form-label {
    display: block;
    margin-bottom: 5px;
    font-weight: 600;
    color: var(--text-color);
}

.form-input,
.form-textarea,
.form-select {
    width: 100%;
    padding: 12px;
    border: 1px solid var(--border-color);
    border-radius: 6px;
    background: var(--card-bg);
    color: var(--text-color);
    font-size: 14px;
    transition: border-color 0.3s ease;
}

.form-input:focus,
.form-textarea:focus,
.form-select:focus {
    outline: none;
    border-color: var(--black);
}

.form-textarea {
    resize: vertical;
    min-height: 100px;
}

.form-actions {
    display: flex;
    gap: 10px;
    margin-top: 25px;
}

/* Modal Styles */
.modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
    backdrop-filter: blur(2px);
}

.modal-content {
    background: var(--card-bg);
    border-radius: 12px;
    width: 90%;
    max-width: 500px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.3);
    border: 1px solid var(--border-color);
}

.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px;
    border-bottom: 1px solid var(--border-color);
}

.modal-header h3 {
    margin: 0;
    color: var(--text-color);
    font-weight: 700;
    font-size: 18px;
}

.btn-close {
    background: none;
    border: none;
    font-size: 20px;
    cursor: pointer;
    color: var(--light-text);
    padding: 0;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 4px;
    transition: all 0.3s ease;
}

.btn-close:hover {
    background: #f0f0f0;
    transform: rotate(90deg);
}

.modal-body {
    padding: 20px;
}

.modal-footer {
    padding: 16px 20px;
    border-top: 1px solid var(--border-color);
    display: flex;
    gap: 10px;
    justify-content: flex-end;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .metrics-cards {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .analytics-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 768px) {
    .main-content {
        padding: 20px;
    }
    
    .metrics-cards {
        grid-template-columns: 1fr;
    }
    
    .main-header {
        flex-direction: column;
        gap: 15px;
    }
    
    .header-actions {
        width: 100%;
        justify-content: flex-start;
    }
    
    .stat-card {
        padding: 20px;
    }
    
    .chart-container {
        height: 250px;
    }
}

@media (max-width: 480px) {
    .main-content {
        padding: 15px;
    }
    
    .content-area {
        padding: 20px;
    }
    
    .modal-content {
        width: 95%;
        margin: 10px;
    }
    
    .modal-footer {
        flex-direction: column;
    }
}

        .footer-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .footer-links {
            display: flex;
            gap: 20px;
        }

        .footer-links a {
            color: var(--white);
            text-decoration: none;
            font-size: 14px;
            transition: color 0.3s ease;
        }

        .footer-links a:hover {
            color: #cccccc;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .main-content {
                padding: 20px;
            }
            
            .projects-grid {
                grid-template-columns: 1fr;
                gap: 16px;
            }
            
            .project-card {
                padding: 16px;
                max-height: 180px;
            }
            
            .project-card:hover {
                max-height: 350px;
            }
            
            .project-stats {
                flex-direction: column;
                gap: 8px;
            }
            
            .project-actions-footer {
                flex-direction: column;
                gap: 8px;
            }
            
            .modal-content {
                width: 95%;
                margin: 10px;
            }
            
            .modal-footer {
                flex-direction: column;
            }
            
            .header-actions .btn {
                padding: 10px 16px;
                font-size: 13px;
            }

            .main-header {
                flex-direction: column;
                gap: 15px;
            }

            .footer-content {
                flex-direction: column;
                gap: 15px;
            }
        }

        @media (max-width: 480px) {
            .project-card {
                max-height: 160px;
            }
            
            .project-card:hover {
                max-height: 300px;
            }
            
            .project-title {
                font-size: 15px;
            }
            
            .project-actions-footer .btn {
                font-size: 11px;
                padding: 6px 10px;
            }
            
            .empty-state {
                padding: 40px 20px;
            }
            
            .empty-icon {
                font-size: 40px;
            }

            .main-content {
                padding: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">