<?php
// Set default values if variables are not set
$page_title = isset($page_title) ? $page_title : '';
$user = isset($user) ? $user : (object)['full_name' => 'User', 'role' => 'user', 'last_login' => null];

// Format last login in IST
if ($user->last_login) {
    $last_login = new DateTime($user->last_login, new DateTimeZone('UTC'));
    $last_login->setTimezone(new DateTimeZone('Asia/Kolkata'));
    $last_login_display = $last_login->format('M j, Y g:i A');
} else {
    $last_login_display = 'Never';
}
?>

<aside class="sidebar" id="sidebar">
    <div class="sidebar-logo">
        <span>GO PRODUCTIONS</span>
        <button class="toggle-sidebar" onclick="toggleSidebar()" title="Toggle Sidebar">
            <i class="fas fa-chevron-left"></i>
        </button>
    </div>
    
    <nav class="sidebar-menu">
        <!-- Dashboard -->
        <a href="<?php echo base_url('admin/dashboard'); ?>" class="menu-item <?php echo ($page_title == 'Dashboard') ? 'active' : ''; ?>">
            <i class="fas fa-tachometer-alt"></i>
            <span>Dashboard</span>
        </a>

        <!-- Project Management -->
        <a href="<?php echo base_url('project/create'); ?>" class="menu-item <?php echo ($page_title == 'New Project') ? 'active' : ''; ?>">
            <i class="fas fa-plus-circle"></i>
            <span>New Project</span>
        </a>
        <a href="<?php echo base_url('project'); ?>" class="menu-item <?php echo ($page_title == 'Open Project') ? 'active' : ''; ?>">
            <i class="fas fa-folder-open"></i>
            <span>Open Project</span>
        </a>
        <a href="<?php echo base_url('project/search'); ?>" class="menu-item <?php echo ($page_title == 'Search Projects') ? 'active' : ''; ?>">
            <i class="fas fa-search"></i>
            <span>Search Projects</span>
        </a>
        <a href="<?php echo base_url('admin/agencies'); ?>" class="menu-item <?php echo ($page_title == 'Agencies') ? 'active' : ''; ?>">
            <i class="fas fa-layer-group"></i>
            <span>Agencies</span>
        </a>
        
        <!-- Analytics -->
        <a href="<?php echo base_url('admin/analytics'); ?>" class="menu-item <?php echo ($page_title == 'Analytics') ? 'active' : ''; ?>">
            <i class="fas fa-chart-bar"></i>
            <span>Analytics</span>
        </a>
        
        <!-- Activity -->
        <a href="<?php echo base_url('admin/activity'); ?>" class="menu-item <?php echo ($page_title == 'Activity') ? 'active' : ''; ?>">
            <i class="fas fa-history"></i>
            <span>Activity</span>
        </a>
        
        <!-- Users - Only show for Admin -->
        <?php if ($user->role === 'admin'): ?>
        <a href="<?php echo base_url('admin/users'); ?>" class="menu-item <?php echo ($page_title == 'Users') ? 'active' : ''; ?>">
            <i class="fas fa-users"></i>
            <span>Users</span>
        </a>
        <?php endif; ?>
        
        <!-- Server Config - Only show for Admin -->
        <?php if ($user->role === 'admin'): ?>
        <a href="<?php echo base_url('admin/server'); ?>" class="menu-item <?php echo ($page_title == 'Server Config') ? 'active' : ''; ?>">
            <i class="fas fa-server"></i>
            <span>Server Config</span>
        </a>
        <?php endif; ?>
        
        <!-- Settings -->
      
        
        <!-- Support -->
        <a href="<?php echo base_url('admin/support'); ?>" class="menu-item <?php echo ($page_title == 'Support') ? 'active' : ''; ?>">
            <i class="fas fa-life-ring"></i>
            <span>Support</span>
        </a>
    </nav>

    <div class="sidebar-footer">
        <div class="user-profile">
            <?php if ($user->role === 'admin'): ?>
                <img src="<?php echo base_url('assets/images/image.png'); ?>" alt="Admin" class="user-profile-img" onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMjAiIGN5PSIyMCIgcj0iMjAiIGZpbGw9IiMwMDAwMDAiLz4KPHN2ZyB4PSI4IiB5PSI4IiB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDExQzE0LjIwOTEgMTEgMTYgOS4yMDkxIDE2IDdDMTYgNC43OTA4NiAxNC4yMDkxIDMgMTIgM0M5Ljc5MDg2IDMgOCA0Ljc5MDg2IDggN0M4IDkuMjA5MTQgOS43OTA4NiAxMSAxMiAxMVoiIGZpbGw9IiNGRkZGRkYiLz4KPHBhdGggZD0iTTEyIDEzQzguMTMzIDEzIDUgMTYuMTMzIDUgMjBIMTlDMTkgMTYuMTMzIDE1Ljg2NyAxMyAxMiAxM1oiIGZpbGw9IiNGRkZGRkYiLz4KPC9zdmc+Cjwvc3ZnPgo='">
            <?php else: ?>
                <img src="<?php echo base_url('assets/images/user-avatar.png'); ?>" alt="User" class="user-profile-img" onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMjAiIGN5PSIyMCIgcj0iMjAiIGZpbGw9IiM2NjY2NjYiLz4KPHN2ZyB4PSI4IiB5PSI4IiB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDExQzE0LjIwOTEgMTEgMTYgOS4yMDkxIDE2IDdDMTYgNC43OTA4NiAxNC4yMDkxIDMgMTIgM0M5Ljc5MDg2IDMgOCA0Ljc5MDg2IDggN0M4IDkuMjA5MTQgOS43OTA4NiAxMSAxMiAxMVoiIGZpbGw9IiNGRkZGRkYiLz4KPHBhdGggZD0iTTEyIDEzQzguMTMzIDEzIDUgMTYuMTMzIDUgMjBIMTlDMTkgMTYuMTMzIDE1Ljg2NyAxMyAxMiAxM1oiIGZpbGw9IiNGRkZGRkYiLz4KPC9zdmc+Cjwvc3ZnPgo='">
            <?php endif; ?>
            <div class="user-info">
                <p><?php echo htmlspecialchars($user->full_name); ?></p>
                <small>
                    <?php echo ucfirst($user->role); ?> 
                    <?php if ($user->role === 'admin'): ?>
                        👑
                    <?php endif; ?>
                    <br>
                    Last login: <?php echo $last_login_display; ?> IST
                </small>
            </div>
        </div>
        <a href="<?php echo base_url('auth/logout'); ?>" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i>
            <span>LOGOUT</span>
        </a>
    </div>
</aside>

<style>
    /* Sidebar Styles */
    .sidebar {
        width: 250px;
        background-color: var(--sidebar-bg);
        color: var(--white);
        display: flex;
        flex-direction: column;
        flex-shrink: 0;
        transition: width 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: sticky;
        top: 0;
        height: 100vh;
        overflow-y: auto;
        border-right: 1px solid #333;
        z-index: 100;
    }

    .sidebar.collapsed {
        width: 70px;
    }

    /* Logo Area */
    .sidebar-logo {
        padding: 25px 20px;
        font-size: 20px;
        font-weight: 800;
        color: var(--white);
        text-align: left;
        border-bottom: 1px solid #333;
        letter-spacing: 1.5px;
        text-transform: uppercase;
        display: flex;
        align-items: center;
        justify-content: space-between;
        background: var(--black);
        position: sticky;
        top: 0;
        z-index: 100;
        height: 80px;
    }

    .sidebar-logo span {
        font-weight: 900;
        letter-spacing: 2px;
        font-size: 18px;
    }

    .toggle-sidebar {
        background: none;
        border: none;
        color: var(--white);
        cursor: pointer;
        font-size: 16px;
        width: 32px;
        height: 32px;
        border-radius: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
        flex-shrink: 0;
    }

    .toggle-sidebar:hover {
        background-color: #333;
    }

    /* Menu Styles */
    .sidebar-menu {
        display: flex;
        flex-direction: column;
        flex-grow: 1;
        padding: 20px 0;
        overflow-y: auto;
    }

    .menu-item {
        display: flex;
        align-items: center;
        padding: 14px 20px;
        color: #e0e0e0;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border-left: 3px solid transparent;
        margin: 2px 0;
    }

    .menu-item i {
        font-size: 16px;
        margin-right: 15px;
        width: 20px;
        text-align: center;
        flex-shrink: 0;
    }

    .menu-item:hover {
        color: var(--white);
        background-color: #1a1a1a;
        border-left-color: #333;
    }

    .menu-item.active {
        color: var(--white);
        background-color: #1a1a1a;
        border-left: 3px solid var(--primary-color);
        font-weight: 700;
    }

    .menu-item span {
        font-weight: 600;
        letter-spacing: 0.3px;
    }

    /* Collapsed State */
    .sidebar.collapsed .sidebar-logo span,
    .sidebar.collapsed .menu-item span,
    .sidebar.collapsed .user-info,
    .sidebar.collapsed .logout-btn span {
        display: none;
    }

    .sidebar.collapsed .menu-item {
        justify-content: center;
        padding: 14px;
    }

    .sidebar.collapsed .menu-item i {
        margin-right: 0;
    }

    .sidebar.collapsed .sidebar-footer {
        padding: 15px 10px;
    }

    /* Footer Styles */
    .sidebar-footer {
        padding: 20px;
        border-top: 1px solid #333;
        background-color: var(--black);
        position: sticky;
        bottom: 0;
        margin-top: auto;
    }

    .user-profile {
        display: flex;
        align-items: center;
        margin-bottom: 15px;
    }

    .user-profile-img {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
        margin-right: 12px;
        border: 2px solid var(--primary-color);
        flex-shrink: 0;
    }

    .user-info {
        line-height: 1.4;
    }

    .user-info p {
        font-size: 14px;
        font-weight: 700;
        margin: 0;
        color: var(--white);
    }

    .user-info small {
        font-size: 11px;
        color: #b0b0b0;
        font-weight: 500;
    }

    .logout-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        padding: 12px;
        background-color: var(--white);
        color: var(--black);
        border: none;
        border-radius: 8px;
        cursor: pointer;
        font-size: 13px;
        font-weight: 700;
        transition: all 0.3s ease;
        text-decoration: none;
        letter-spacing: 0.5px;
    }

    .logout-btn:hover {
        background-color: #f8f9fa;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(255, 255, 255, 0.1);
    }

    .logout-btn i {
        margin-right: 8px;
        font-size: 14px;
    }

    /* Scrollbar Styling */
    .sidebar-menu::-webkit-scrollbar {
        width: 4px;
    }

    .sidebar-menu::-webkit-scrollbar-track {
        background: #1a1a1a;
    }

    .sidebar-menu::-webkit-scrollbar-thumb {
        background: #333;
        border-radius: 2px;
    }

    .sidebar-menu::-webkit-scrollbar-thumb:hover {
        background: #555;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            z-index: 1000;
            transform: translateX(-100%);
        }
        
        .sidebar.mobile-open {
            transform: translateX(0);
        }
    }
</style>